package GetStatusListing; 

###############################################################################
# UNICOS
#
#    based on a version for the FZJ Cray T90 with help from Mathilde Romberg
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# UNICOS

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my($command, $output, $result, $bssid, $state, $ustate, $result);

    debug_report("Finding all jobs on BSS");

    # Form the request command. 
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if($? != 0) {
        failed_report($output);
    }
    else {
        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its _Unicore_ state.

        # The output format of the interesting lines is:
        # xxxxxx.junk junk ..... junk Status
        #
        # Where xxxxx is the Job id to return, the number of
        # junk fields is variable and we interpret the first letter
        # of status (status may be absent!)
        #                                 state           job id
        # e.g.
        #
        # 48164.zam006  test    zdv549   pe000p02@zam006             999 262144  21600 Qqu
        # ^^^^^                                                                        ^
        # 48163.zam006  test    zdv549   pe000p02@zam006       83330   22    479  21600 R04
        # ^^^^^                                                                         ^
        #
        # There are also some uninteresting lines. 
        #
        # Do not differentiate between pipe and batch queues
        #
        # Ignore the minor states

        $result = "QSTAT\n";

        $_ = $output;
        #
        # Terms are: start of a line
        #            digit (integer) <- put into $1
        #            "." marks end of integer
        #            any amount of junk
        #            " " marks start of last word on a line
        #            Character       <- put into $2
        #            (possibly) more characters in the word
        #            (possibly) space
        #            ties match to one line
        #
        # Note g to resume from end of last match
        while(/^(\d+)\..* (\S)\S*\s*$/gm) {

 command_report (" while schleife 1>>$1<<   2 >>$2<<");

            $bssid = $1;
            $state = $2;

            # Catches all known values.
            # Absent statuses are treated as unknown as status will contain a number
            $ustate = "UNKNOWN";

            # A - arriving, queue has not processed, so not running
            # D - departing, leaving pipe so not running
            # Q - queued
            # W - waiting (for date or pipe q available)
            $ustate = "QUEUED"  if $state =~ /A|D|Q|W/;

            # E - exiting, finished execution but implicit output written?
            # R - running (or ROUTING in pipe queue AAAARRRGGGGHH :-( )
            $ustate = "RUNNING" if $state =~ /R|E/ ;

            # C - checkpointed ?
            # H - held
            # P - preempted, assume that it will be automatically restarted
            # S - suspended
            $ustate = "SUSPENDED" if $state =~ /C|H|P|S/ ;

			# can also report FROZEN if this is supported by BSS (hedl and resources released)

            # U - unknown

            # Add to the returned lines
            $result = "$result $bssid $ustate\n";

        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }

}
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
