package LocalInfo;    # some customisation of the Submit script for SGE

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(add_local_info);

use strict;

#
# Called from submit() to add local batch scheduler submission
# info to the job submit script
#

sub add_local_info {
    my $from_njs = shift;

    # remove the shell identification line
    $from_njs =~ s/#!\/bin\/sh/#/;

    # create the beginning of the script with needed values
    my $inject = "#!/bin/sh\n#\n#\$ -S /bin/bash\n#\n";

    # add all of njs text
    $inject .= $from_njs;

    return $inject;
}
