package GetStatusListing;    # SPECIALISATION FOR SUN GRID ENGINE

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

#use Reporting qw(start_report failed_report ok_report debug_report);
use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all UNICORE jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_GETSTATUSLISTING in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED
#        Optionally, a third word gives the queue name
#
#        The list must include all UNICORE jobs (but can contain extra jobs)
#
sub get_status_listing {

    my (
        $command, $output, $result, $bssid, @lines,
        $junk,    $bssid,  $state,  $data,  $ustate
    );

    debug_report("Finding all jobs from Unicore");

    # Get all the processes on the system, with sufficient information
    # to be able to derive the Unicore ones

    # Form the request command.
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its _Unicore_ state

        # There can be many TSIs running, return about all Jobs

        $result = "QSTAT\n";
        $_      = $output;

        #
        while (/^\s*(\d+)\s+[\d\.]+\s+\S+\s+\w+\s+([hqwRrsdE]+)\s+/gm) {

            $bssid = $1;
            $state = $2;

        # Catches all known values.
        # Absent statuses are treated as unknown as status will contain a number
            $ustate = "UNKNOWN";

            #        Q -  job is queued, eligable to run or routed.
            #        T -  ??

            $ustate = "QUEUED" if $state =~ /q|t/;

            #        R -  job is running.
            $ustate = "RUNNING" if $state =~ /r/;

            #        S - suspended
            $ustate = "SUSPENDED" if $state =~ /s/;

            #        E - Error
            $ustate = "COMPLETED" if $state =~ /E/;

            # Add to the returned lines
            $result = "$result $bssid $ustate\n";

        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }
}

#
# 16-09-08 Bernd Schuller : updated using the patches from Nadya Williams UZH
# 04-05-01 Sven van den Berghe fecit Created from 3.0 TSI for Unicore 3.5
#
#                  Copyright (c) Fujitsu Ltd 2000 - 2002
#
#     Use and distribution is subject to the Community Source Licence.
#
# Further information is available from www.unicore.org or arcon@fecit.co.uk.
#
