package GetStatusListing;    # SPECIALISATION FOR TORQUE

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

#use Reporting qw(start_report failed_report ok_report debug_report);
use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all UNICORE jobs
# and returns a list of their identifier together with their status
#
# Called in response to a #TSI_GETSTATUSLISTING

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#  First line is "QSTAT",
#  followed by a line per found job, first word is BSS job identifier
#  and the second word is one of RUNNING, QUEUED, SUSPENDED or COMPLETED
#  Optionally, a third word can be added which is the queue name
#
#  The list must include all UNICORE jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my (
        $command, $output, $result, $bssid,  @lines, $junk,
        $bssid,   $state,  $data,   $ustate, $queue_name
    );

    debug_report("Finding all jobs from UNICORE");

    # Get all the processes on the system, with sufficient information
    # to be able to derive the UNICORE ones

    # Form the request command.
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its UNICORE state

# Example output we expect from Torque:
#
# zam285.zam.kfa-juelich.de:
#                                                                    Req'd  Req'd   Elap
# Job ID               Username Queue    Jobname    SessID NDS   TSK Memory Time  S Time
# -------------------- -------- -------- ---------- ------ ----- --- ------ ----- - -----
# 83.zam285.zam.kfa-ju rbreu    batch    New_Script  16522     1  -- 1000mb 00:00 C 00:00
# 83.zam285.zam.kfa-ju rbreu    batch    torque_tes  16864     1  --    --  01:00 R   --
# 84.zam285.zam.kfa-ju rbreu    batch    torque_tes    --      1  --    --  01:00 Q   --

        $result = "QSTAT\n";
        $_      = $output;

# we want to extract the numeric part of the job ID, the queue name and the state...
        while ( /^\s*(\d+)\.\S+\s+\S+\s+(\S+)\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+([CEHQRTWS]+)\s+\S+/gm )
        {

            $bssid      = $1;
            $queue_name = $2;
            $state      = $3;

            #Torque returns on of these states:
            #
            #   C -  Job is completed after having run/
            #   E -  Job is exiting after having run.
            #   H -  Job is held.
            #   Q -  job is queued, eligible to run or routed.
            #   R -  job is running.
            #   T -  job is being moved to new location.
            #   W -  job is waiting for its execution time
            #        (-a option) to be reached.
            #   S -  (Unicos only) job is suspend.

            $ustate = "UNKNOWN";

            $ustate = "QUEUED" if $state =~ /Q|T|W/;

            $ustate = "RUNNING" if $state =~ /R|E/;

            $ustate = "SUSPENDED" if $state =~ /S|H/;

            $ustate = "COMPLETED" if $state =~ /C/;

            # Add to the returned lines
            $result = "$result $bssid $ustate $queue_name\n";

        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }
}

#                  Copyright (c) Fujitsu Ltd 2000 - 2002
#
#     Use and distribution is subject to the Community Source Licence (LICENCE.FLE)
#
#         Further information is available from www.unicore.eu
#
