package Submit;

require Exporter;
@ISA       = qw(Exporter);
@EXPORT_OK = qw(submit);
use File::Path qw(mkpath);
use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);
use CommonUtils qw(addperms);
use strict;

BEGIN {
    $Submit::tsi_unique_file_name = "TSI_unique_file_$$";    # $$ = process id
    $Submit::neutral_dir          = $ENV{PWD};

    if ( $Submit::neutral_dir =~ m/(.*)/s ) {
        $Submit::neutral_dir = $1;
    }
}

sub submit {

    my $from_njs = shift;
    $from_njs =~ s/\$USER/$ENV{USER}/g;
    $from_njs =~ s/\$HOME/$ENV{HOME}/g;

    # First clear all command line sections from previous iterations
    my $jobname       = "";
    my $outcome_dir   = "";
    my $uspace_dir    = "";
    my $time          = "";
    my $memory        = "";
    my $nodes         = "";
    my $processors    = "";
    my $fast_fs       = "";
    my $large_fs      = "";
    my $home_fast_fs  = "";
    my $home_large_fs = "";
    my $queue         = "";
    my $email         = "";
    my $interactive   = "";
    my $arch          = "";
    my $os            = "";
    my $stdout        = "stdout";
    my $stderr        = "stderr";

    $_ = $from_njs;
    while (/#TSI_(\S+) (.*)\n/g) {
        $jobname       = $2 if $1 eq "JOBNAME";
        $outcome_dir   = $2 if $1 eq "OUTCOME_DIR";
        $uspace_dir    = $2 if $1 eq "USPACE_DIR";
        $time          = $2 if $1 eq "TIME";
        $memory        = $2 if $1 eq "MEMORY";
        $nodes         = $2 if $1 eq "NODES";
        $processors    = $2 if $1 eq "PROCESSORS";
        $fast_fs       = $2 if $1 eq "FASTFS";
        $large_fs      = $2 if $1 eq "LARGEFS";
        $home_fast_fs  = $2 if $1 eq "HOMEFASTFS";
        $home_large_fs = $2 if $1 eq "HOMELARGEFS";
        $queue         = $2 if $1 eq "QUEUE";
        $email         = $2 if $1 eq "EMAIL";
        $interactive   = $2 if $1 eq "PREFER_INTERACTIVE";
        $stdout        = $2 if $1 eq "STDOUT";
        $stderr        = $2 if $1 eq "STDERR";
    }

    # Get Arch and OS name
    my @req = split( /-/, $queue );
    $arch = $req[0];
    $os   = $req[1];

    if ( $interactive eq "true" ) {
        start_report("Interactively executing a job");
    }
    else {
        start_report("Submitting a job to the BSS");
    }

    # Location of Stdout and Stderr
    my $stdout_loc = "-o $outcome_dir/$stdout ";
    my $stderr_loc = "-e $outcome_dir/$stderr ";

    # cd to the Uspace directory, will write a file soon
    if ( chdir($uspace_dir) == 0 ) {
        failed_report("Could not cd to Uspace $uspace_dir because $!");
        return 0;
    }

    # Making outcome directory and change permission
    mkpath $outcome_dir unless -e $outcome_dir;
    addperms 0700, $outcome_dir;

    # Open request file from NJS
    open( EMSCRIPT, ">$Submit::tsi_unique_file_name" );
    print EMSCRIPT $from_njs;
    close(EMSCRIPT);

    #-------------------------------------------------------------------
    # Get "UC_DECISION filename" & "Portfolio filename" from NJS message.
    #-------------------------------------------------------------------

    my $DC = `cat $Submit::tsi_unique_file_name |grep decision`;
    my $PF = `cat $Submit::tsi_unique_file_name |grep .PF`;

    my @array = split( /\;/, $DC );

    # temp00 = UC_DECISION_FILE=/.../.../.decision/..
    # temp01 = export UC_DECISION_FILE
    my $temp00 = $array[0];
    my $temp01 = $array[1];

    @array = split( /\//, $temp00 );
    for ( my $i = 0 ; $i < @array ; $i++ ) {
        if ( $array[$i] =~ /^\.decision/ ) {
            $Submit::dc = $array[$i];
        }
    }

    # Create new UC_DECISION_FILE definition
    my $newdc = "UC_DECISION_FILE=$Submit::dc" . ";" . "$temp01";

    undef $temp00;
    undef $temp01;

    # Get Portofolio file name
    @array = split( /\s/, $PF );
    for ( my $j = 0 ; $j < @array ; $j++ ) {
        if ( $array[$j] =~ /^.PF/ ) {
            $Submit::pf = $array[$j];
        }

        # Check command script to get imported file information
        # Check file existence and owner
        elsif ( ( -f $array[$j] ) && ( -o $array[$j] ) ) {
            $Submit::transfer_input .= "$array[$j],";
        }
    }

    #-------------------------------------------------------
    # Modify not to change directory & delete "USPACE_WD"
    # (cd -> #cd)
    #-------------------------------------------------------

    open IN, "$Submit::tsi_unique_file_name";
    while (<IN>) {
        my $data = $_;

        # Avoid changing directory to  USPACE_WD (cd -> #cd)
        $data =~ s/cd \$USPACE_WD/\#cd \$USPACE_WD/g;

        # Add permission for transfer files (chmod +x ./* )
        $data =~ s/\#TSI_SCRIPT/\#TSI_SCRIPT\nchmod +x .\/\*/g;

        # Replace UC_DECISION_FILE definition( .decision only)
        # absolute path -> file name only
        $data =~ s/$DC/$newdc/g;

        # Remove UC_DECISION_FILE
        # absolute path -> file name only
        $data =~ s/\$USPACE_WD\// /g;

        push @Submit::alldata, $data;
    }
    close IN;

    # Update $Submit::tsi_unique_file_name
    open OUT, ">$Submit::tsi_unique_file_name";
    foreach (@Submit::alldata) {
        print OUT $_;
    }
    close OUT;

    #----------------------------------------------
    # Get Script file or Cmmand name
    # (preparation for making condor submit script)
    #----------------------------------------------

    # for perl taint mode error.
    if ( $Submit::pf =~ /^([-\@\w.]+$)/ ) {
        $Submit::pf = $1;
    }

    my $data  = `cat $Submit::pf`;
    my $flist = `/bin/ls -a1 $uspace_dir`;

    @array = split( /\n/, $flist );
    my $line = @array;
    my $nof  = 0;
    my $fname;
    for ( my $i = 0 ; $i <= $line ; $fname = $array[ $i++ ] ) {
        if (   -f $fname
            && $fname ne ""
            && $fname ne "."
            && $fname ne ".."
            && $fname ne $Submit::tsi_unique_file_name )
        {
            if ( $nof++ != 0 ) { $Submit::transfer_input .= ","; }
            $Submit::transfer_input .= "$fname";
        }
    }

    #--------------------------------
    # Change Script file name
    # to show job name by condor_q
    #--------------------------------

    if ( $jobname =~ /(.*)(\_EXECUTESCRIPT)/ ) {
        $jobname = $1;

        if ( $jobname eq "" ) {

            # default jobname is set if jobname is blank.
            $jobname = $Submit::tsi_unique_file_name;
        }

    }

    # Create renamed Script file
    open IN, "$Submit::tsi_unique_file_name";
    while (<IN>) {
        my $data = $_;
        push @Submit::alldata01, $data;
    }
    close IN;

    open OUT, ">$jobname";
    foreach (@Submit::alldata01) {
        print OUT $_;
    }
    close OUT;

    #---------------------------------
    # Create Condor Submit Script
    #---------------------------------

    # Set Condor Submit Script file
    $Submit::condor_submit_script = "condor_$$.cmd";

    open( FILE, "> $Submit::condor_submit_script" );
    print FILE "Iwd = $uspace_dir \n";
    print FILE "executable = $jobname\n";
    print FILE "universe = vanilla\n";
    print FILE "output = $stdout.\$(Cluster)\n";
    print FILE "error = $stderr.\$(Cluster)\n";
    print FILE "log = log.\$(Cluster)\n";
    print FILE "should_transfer_files = IF_NEEDED\n";
    print FILE "when_to_transfer_output = ON_EXIT\n";
    print FILE "transfer_input_files =$Submit::transfer_input\n";
    print FILE
"requirements = Arch==\"$arch\" \&\& OpSys==\"$os\" \&\& Memory\>= $memory \n";
    print FILE "queue \n";
    close(FILE);

    undef $DC;
    undef $PF;
    undef $newdc;
    undef $data;
    undef $flist;
    undef $fname;
    undef $nof;
    undef $Submit::dc;
    undef $Submit::pf;
    undef $Submit::transfer_input;
    undef @array;
    undef @Submit::alldata;
    undef @Submit::alldata01;

    #-----------------------------------
    # Job Submit
    #-----------------------------------

    if ( $interactive eq "true" ) {
        my $command = "$Submit::tsi_unique_file_name";
        addperms 0700, $command;
        command_report($command);
        `./$command > $outcome_dir/$stdout 2> $outcome_dir/$stderr`;
        ok_report();
    }
    else {
        addperms 0700, $jobname;

        my $command = "$main::submit_cmd  $Submit::condor_submit_script";

        command_report($command);

        my $output = `($command) 2>&1`;

        if ( $? != 0 ) {
            failed_report($output);
        }
        else {

            # Get JobID
            if ( $output =~ /cluster(\s)(\d+)/ ) {
                my $jobid = $2;
                my $res   = $jobid;
                $res =~ s/[0-9]//g;

                if ( length($res) == 0 ) {
                    debug_report("Job submitted OK. Identifier: $jobid");

                    # Report JobID to NJS
                    print main::CMD_SOCK "$jobid\n";

                    # hard link stdout/err
                    # .$jobid needs to avoid being overriden by Do N Task.
                    `ln  $uspace_dir/$stdout.$jobid $outcome_dir/$stdout`;
                    `ln  $uspace_dir/$stderr.$jobid $outcome_dir/$stderr`;
                }
                else {
                    failed_report("Job submit failed?: $jobid $output");
                }
            }
            else {
                failed_report("Request id not found in: $output");
            }
        }
    }
}

