package GetStatusListing;

require Exporter;

@ISA       = qw(Exporter);
@EXPORT_OK = qw(get_status_listing);

use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);
use strict;

sub get_status_listing {

    my ( $command, $output, $result, $bssid, $state, $ustate, $result );

    debug_report("Finding all jobs on BSS");

# Form the request command.
# Add condor_status command option to get ClusterId(integer) and JobStatus(integer)
    $command =
      "$main::qstat_cmd -format \"%d \" ClusterId  -format \"%d\n\" JobStatus";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        $result = "QSTAT\n";

        #Get JobID and Status, Send CMD_SOCK to NJS
        my @lines = split( /\n/, $output );

        foreach (@lines) {

            # ID=ClusterId, ST=JobStatus
            my ( $ID, $ST ) = split( /\s+/, $_ );

            $bssid = $ID;
            $state = $ST;

         # Catches all known values.
         # Absent status is treated as "UNKNOWN" as status will contain a number
         #
         # I(Idle)      =1
         # R(Runing)    =2
         # X(uneXpanded)=3
         # C(Completed) =4
         # H(Hold)      =5

            $ustate = "UNKNOWN";
            $ustate = "QUEUED" if $state =~ /1/;
            $ustate = "RUNNING" if $state =~ /2|4/;
            $ustate = "SUSPENDED" if $state =~ /5/;

            # Add to the returned lines
            $result = "$result $bssid $ustate\n";
        }

        # Report JobStatus to NJS
        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");

    }
}

