package Submit;

###############################################################################
# CCS shell version
#
# UNTESTED
#
#    Based on 3.0 CCS port by Achim Streit at Paderborn
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(submit);

use File::Path qw(mkpath);

use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);
use CommonUtils qw(addperms);

use strict;

# Submit the script to the BSS

# arg 1 = The script (this is called because the script contains the string "#TSI_SUBMIT");
#
# Returns void to TSI
#         on success returns the BSS identifier assigned to the job
#         on fail return a message
#

BEGIN {

    # --------------------------------------------------------------------
    # needed for having unique files ...
    $Submit::counter = 1;

    # Always cd to some neutral place when not doing something
    $Submit::neutral_dir = $ENV{PWD};
    if ( $Submit::neutral_dir =~ m/(.*)/s ) {
        $Submit::neutral_dir = $1;
    }

}

sub submit {

    my $from_njs = shift;

    # Correction for $HOME or $USER in root directories SvdB 11 Feb 2002
    # Substitute for these values as the executed script's
    # environment will not (and if it did the values will
    # be wrong). This is safe as thes script seen here is
    # completely generated by the NJS and so we will not be
    # messing with any user created code.

    $from_njs =~ s/\$USER/$ENV{USER}/g;
    $from_njs =~ s/\$HOME/$ENV{HOME}/g;

    # Get the information from the NJS (embedded as comments)
    #
    # Not picking up defnitions of Software Resources sent as:
    # #TSI_SWR<name>

    # First clear all command line sections from previous iterations
    my $jobname       = "";
    my $outcome_dir   = "";
    my $uspace_dir    = "";
    my $time          = "";
    my $memory        = "";
    my $nodes         = "";
    my $processors    = "";
    my $fast_fs       = "";
    my $large_fs      = "";
    my $home_fast_fs  = "";
    my $home_large_fs = "";
    my $queue         = "";
    my $email         = "";
    my $interactive   = "";
    my $stdout        = "stdout";
    my $stderr        = "stderr";

    $_ = $from_njs;
    while (/#TSI_(\S+) (.*)\n/g) {
        $jobname       = $2 if $1 eq "JOBNAME";
        $outcome_dir   = $2 if $1 eq "OUTCOME_DIR";
        $uspace_dir    = $2 if $1 eq "USPACE_DIR";
        $time          = $2 if $1 eq "TIME";
        $memory        = $2 if $1 eq "MEMORY";
        $nodes         = $2 if $1 eq "NODES";
        $processors    = $2 if $1 eq "PROCESSORS";
        $fast_fs       = $2 if $1 eq "FASTFS";
        $large_fs      = $2 if $1 eq "LARGEFS";
        $home_fast_fs  = $2 if $1 eq "HOMEFASTFS";
        $home_large_fs = $2 if $1 eq "HOMELARGEFS";
        $queue         = $2 if $1 eq "QUEUE";
        $email         = $2 if $1 eq "EMAIL";
        $interactive   = $2 if $1 eq "PREFER_INTERACTIVE";
        $stdout        = $2 if $1 eq "STDOUT";
        $stderr        = $2 if $1 eq "STDERR";
    }

    if ( $interactive eq "true" ) {
        start_report("Interactively executing a job");
    }
    else {
        start_report("Submitting a job to the BSS");
    }

    # Jobname: not available under CCS
    if ( $jobname eq "NONE" ) {
        $jobname = "";
    }
    else {
        $jobname = "";
    }

    # Queue: not available under CCS
    if ( $queue eq "NONE" ) {
        $queue = "";
    }
    else {
        $queue = "";
    }

    # Job memory requirements in megabytes, this can be
    # either for the whole job, for each processor or
    # for each node depending on how the IDB is set up
    # (see PER_xxxx_LIMITS)
    # Memory: not available under CCS
    $memory = "";

    # Create a file name to which scripts are written for the submits to
    # the batch sub-system. This needs to be unique as there may be
    # more than one TSI running, so base on the process id and a counter..
    $Submit::tsi_unique_file_name = "TSI_temp_file_$$.$Submit::counter";
    $Submit::counter++;

    #    $Submit::batch_file = "$Submit::unique_TSI_script."."batch";
    $Submit::batch_file = "$Submit::tsi_unique_file_name." . "batch";

    # $nodes is number of nodes required
    #
    # $processors (processors per node) is 1 if the system
    # is not an SMP

    my $worker;

    #debug_report("ACHIM nodes: ".$nodes);
    # check, which worker to take (shell or pshell)
    if ( $nodes == 1 || $nodes eq "NONE" ) {
        $nodes  = "-n 1";
        $worker = "shell";
    }
    elsif ( $nodes >= 2 ) {
        $nodes  = "-n $nodes";
        $worker = "pshell --";

        #debug_report("ACHIM processors: ".$processors);
        # check, if we want more than 1 processor per node envolved
        if ( $processors >= 2 ) {
            $worker = "pshell -np $processors --";
        }
    }

    # Job time requirement. Wallclock time in seconds.
    $time = "-t $time" . "s";

    #debug_report("ACHIM EMAIL: ".$email);
    if ( $email eq "NONE" ) {

        #debug_report("ACHIM NO EMAIL");
        $email = "";
    }
    else {

        #debug_report("ACHIM EMAIL: ".$email);
        $email = "";
    }

    # Tell the BSS to put the batch job's stdout and stderr
    # into these files

    # >>>>>>>>>>>>>>>>>>>>> NEEDS CHECKING
    # (these go to subdirectories created to hold them)

    my $stdout_loc = "-o $outcome_dir/$stdout ";
    my $stderr_loc = "-stderr $outcome_dir/$stderr ";

    # cd to the Uspace directory, will write a file soon and
    # this means that there does not need to be a TSI working
    # directory
    if ( chdir($uspace_dir) == 0 ) {
        failed_report("Could not cd to Uspace $uspace_dir because $!");
        return 0;
    }

 # Make sure that the Outcome directory is there for the stdout and stderr files
    mkpath $outcome_dir unless -e $outcome_dir;

    #    chmod 0700, $outcome_dir;
    #FIXME - is it really OK??? Looks really bad!
    chmod 0777, $outcome_dir;

    # construct the command
    my $command =
"$main::submit_cmd $nodes $time $stdout_loc $stderr_loc -f $uspace_dir/$Submit::batch_file";

#    my $command = "/usr/local/bin/tcsh -c \"$main::submit_cmd $nodes $time $stdout_loc $stderr_loc -f $uspace_dir/$Submit::batch_file\"";
    command_report($command);

    open( EMSCRIPT, ">$Submit::tsi_unique_file_name" );
    print EMSCRIPT $from_njs;
    close(EMSCRIPT);

    if ( $interactive eq "true" ) {
        my $command = "$Submit::tsi_unique_file_name";
        addperms 0700, $command;
        command_report($command);
        `./$command > $outcome_dir/$stdout 2> $outcome_dir/$stderr`;
        ok_report();
    }
    else {

        # chmod is necessary for CCS
        #FIXME - is it really OK??? Looks really bad!
        chmod 0777, $Submit::tsi_unique_file_name;

        # construct a batch script for CCS
        open( BATCHSCRIPT, ">$Submit::batch_file" );

        # for test purpose, ONLY shell is allowed
        print BATCHSCRIPT "$worker $uspace_dir/$Submit::tsi_unique_file_name";
        close(BATCHSCRIPT);

# print the batch_file
#debug_report("CCS batch-file: $worker $uspace_dir/$Submit::tsi_unique_file_name");
#debug_report("CCS batch-file: $uspace_dir/$Submit::batch_file");
#system("cp -r $uspace_dir/ /tmp/");

   # first change to a directory that is seen/available on all nodes (i.e. /tmp)
        debug_report("printing environment: ");
        debug_report( "CCS: " . $ENV{CCS} );
        debug_report( "CCS_ARCH: " . $ENV{CCS_ARCH} );
        debug_report( "CCS_UI_DEF_RESOURCE: " . $ENV{CCS_UI_DEF_RESOURCE} );
        debug_report( "CCS_UI_DEF_PROJECT: " . $ENV{CCS_UI_DEF_PROJECT} );
        debug_report( "HOME: " . $ENV{HOME} );
        debug_report( "PWD: " . $ENV{PWD} );
        debug_report( "USER: " . $ENV{USER} );
        debug_report( "PATH: " . $ENV{PATH} );
        debug_report( "HOSTNAME: " . $ENV{HOSTNAME} );
        debug_report( "SHELL: " . $ENV{SHELL} );
        debug_report("done");

        #    chdir("/tmp") || die "SHIT, can't cd to /tmp !";
        # and execute the command
        my $output = `($command) 2>&1`;

        #    chdir($uspace_dir) || die "SHIT, can't cd to $uspace_dir !";

        # print the output from ccsalloc
        debug_report( "CCS output: " . $output );

        # Parse output
        if ( $? != 0 ) {
            failed_report($output);
        }
        else {

            # Succeeded, return Job Identifier

            # IS THIS RIGHT???
            # parsing for line Request (xxxx/ (want the xxxx)
            # IS THIS RIGHT???

            if ( $output =~ /Request \((.+?)\// ) {
                my $jobid = $1;

                # IS THIS RIGHT???
                # Do we get a reliable failure code from the submit?
                # Assume not and check that we have a valid BSS id
                # check here that we got an integer. If we did assume
                # OK, otherwise report a failure
                # IS THIS RIGHT???
                my $res = $jobid;
                $res =~ s/[0-9]//g;
                if ( length($res) == 0 ) {
                    debug_report("Job submitted OK. Identifier: $jobid");
                    print main::CMD_SOCK "$jobid\n";
                }
                else {
                    failed_report("Job submit failed?: $jobid $output");
                }
            }
            else {
                failed_report("Request id not found in: $output");
            }

        }
    }

    # this removes the two script files ...

    #    unlink $Submit::tsi_unique_file_name;
    #    unlink $Submit::batch_file;

    chdir $Submit::neutral_dir;

}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
