package GetStatusListing;

###############################################################################
# CCS
#
# UNTESTED
#
#    Based on 3.0 CCS port by Achim Streit at Paderborn
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my ( $command, $output, $result, $bssid, $state, $ustate );

    debug_report("Finding all jobs on BSS");

    # Form the request command.
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its _Unicore_ state

        $result = "QSTAT\n";

        ## this is the output of ccsinfo -q
        ##Info about schedule from: 10:23:34 on Wed Nov 22, 2000
        ##Actual scheduler is     : FCFS* (First Come First Serve)
        ##ReqId/Name           Machine Nodes State       Config-Time Release-Time   Typ
        ##--------------------------------------------------------------------------------
        ##    8/unicore_1      YAMATO      1 RUNNING     10:23 10:33          Bat <-- that's we are looking for !
        ##ccsinfo: Bye,Bye (0)
        #
        # Terms are: start of a line
        #            any amount of space
        #            digit (integer) <- put into $1
        #            "/" marks end of integer
        #            junk word
        #            junk word
        #            junk word
        #            State       <- put into $2
        #            junk
        #            ties match to one line
        #

        ### new version of CCS: now it looks like that:
#Info about schedule from: 12:45:57 on Mon Feb 04, 2002
#Machine                 : PSC2
#Actual scheduler is     : FCFS* (First Come First Serve)
#ReqId/Name         Type State       Nodes Config-Time    Release-Time   Duration
#--------------------------------------------------------------------------------
#  147/streit_1     Bat  RUNNING         2 10:46          10:47          1m0s
#ccsinfo: Bye,Bye (0)

        $_ = $output;

        #
        # Terms are: start of a line
        #            any amount of space
        #            digit (integer) <- put into $1
        #            "/" marks end of integer
        #            junk word (name)
        #            junk word (type)
        #            State       <- put into $2
        #            junk (nodes)
        #            junk (config-time)
        #            junk (release-time)
        #            ... more junk
        #            ties match to one line
        #
        # Note g to resume from end of last match
        ### change: take 4th instead of 5th !!

        while (/^\s*(\d+?)\/\S+\s+\S+\s+(\S+).*$/gm) {

            $bssid = $1;
            $state = $2;

            $ustate = "UNKNOWN";
            $ustate = "QUEUED" if $state =~ /QUEUED|QUEUING|CONFIGURING/;
            $ustate = "RUNNING" if $state =~ /RUNNING/;

# can also report FROZEN if this is supported by BSS (hedl and resources released)

            # Add to the returned lines
            $result = "$result $bssid $ustate\n";

            #debug_report("result from ccsinfo call: $result $bssid $ustate");

        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }

}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
