package GetStatusListing;

###############################################################################
#
# Loadleveler on AIX
#
# UNTESTED
#
# Based on V3.0 version developed for Idris and Karlsruhe
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting
  qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my ( $command, $output, $result, $bssid, $state, $ustate );

    debug_report("Finding all jobs on BSS");

    # Form the request command.
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        $result = "QSTAT\n";

        # Test for messages/errors from llq
        if ( $output =~ /llq:/m ) {

            # Got a message, error or just nothing to report?
            if ( $output =~ /no job status to report/m ) {
                print main::CMD_SOCK $result;
                debug_report("qstat executed OK, but found nothing");
                return;
            }
            else {
                failed_report($output);
                return;
            }
        }

        # The llq command has been set up to return just the jobid
        # and the status, no header lines, so just process them
        #
        # The format of each line is: <bssid>.0!<state>
        #  where we want <bssid> and <state>. We expect the ".0" as we submit
        #  only single step jobs. The "!" guaranteed by the llq -r.
        #  (<bssid> is got by matching from line start to .0!)
        #  (<state> is got by matching one or more upper case characters)
        #
        # Previous, numeric part only while(/.?(\d+)\.0!([A-Z]+).*$/gm) {

        $_ = $output;
        while (/(.+)\.0!([A-Z]+).*$/gm) {

            $bssid = $1;
            $state = $2;

            $ustate = "UNKNOWN";

            $ustate = "QUEUED" if $state =~ /^D|^I|^P/;

            $ustate = "SUSPENDED" if $state =~ /^H|^S/;

# can also report FROZEN if this is supported by BSS (hedl and resources released)

            # Treat these as running since the NJS
            # says that end is when job goes from queue
            # (note that the ST and SX choices override the S from suspended)
            $ustate = "RUNNING" if $state =~ /^R|^C|^N|^T|^V|^X|ST|SX/;

            # Add to the returned lines
            $result = "$result $bssid $ustate\n";

        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }

}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
