#!/usr/bin/expect -f

#
# this is a wrapper around scp
# it automates the interaction required
# to enter the password. Such a wrapper
# is required for scp data staging support.
# automated file transfer via scp
#
# Prerequisites: 
# The TCL Expect tool is used. 
#
# Arguments:
# 1: source, 2: target, 3: password
#

set source [lindex $argv 0]
set target [lindex $argv 1]
set password [lindex $argv 2]
set timeout 10

# start the scp process
spawn scp "$source" "$target"

# handle the interaction
expect {
   "passphrase" {
     send "$password\n"
     exp_continue
    } "password:" {
     send "$password\n"
     exp_continue
    } "yes/no)?" {
     send "yes\n"
     exp_continue
    } timeout {
      puts "Timeout."
      exit 2
    } -re "." {
      exp_continue
    } eof {
      catch wait result
      exit [lindex $result 3]
    }
    default {
      exit 1
    }
}
