#!/usr/bin/env perl
#
# This script wraps 'scp' and handles the
# interactive bits using the Perl Expect module
#
# If Expect.pm is not installed on your system, you can
# usually install it from cpan with
#
#  $>sudo cpan Expect
#

use strict;
use Expect;

my $scp      = "scp";
my $source   = shift;
my $target   = shift;
my $password = shift;
my $timeout  = 10;

my $scp_exp = new Expect;
$scp_exp->spawn("$scp $source $target") or die "Cannot spawn $scp: $!\n";

$scp_exp->expect(
    5,
    [ 'yes/no', sub { my $exph = shift; print $exph "yes\r"; exp_continue; } ],
    [
        'password:',
        sub { my $exph = shift; print $exph "$password\r"; exp_continue; }
    ],
    [
        'passphrase',
        sub { my $exph = shift; print $exph "$password\r"; exp_continue; }
    ],
    [ '-re', '.', sub { exp_continue; } ],
);

$scp_exp->soft_close();
