#
#Dummy reservation module
#

package ResourceReservation;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK =
  qw(execute_reservation make_reservation cancel_reservation query_reservation);

use Reporting qw(initial_report failed_report debug_report ok_report);
use Submit qw(submit);

use strict;

BEGIN {
    initial_report("Resource reservation dummy implementation");
}

#
#make a reservation: not supported in this dummy module!
#
# arg1: NJS command
#
#
# The NJS command includes the resources as used by the Submit command,
# and the requested starttime in ISO 8601 format
#
# Returns:
#
#  TSI_OK
#  reservationID
#
#
# Example:
#
#
#   #TSI_MAKE_RESERVATION
#   #TSI_STARTTIME 2007-11-08T09:46:58+0100
#   #TSI_TIME 3600
#    # etc
#

sub make_reservation {

    my $njs_command = shift;
    failed_report("Resource reservation NOT SUPPORTED by this TSI.");

    my $start_time;

    #extract start time (see above for format)
    if ( $njs_command =~ m/#TSI_STARTTIME (\S+)/ ) {
        $start_time = $1;
    }

    #
    #a real implementation must return the reference:
    #ok_report("$new_reservation_id");

}

#
#cancel a reservation: not supported in this dummy module!
#
#arg1: NJS command
#
# The NJS command includes the reservation ID
#
# Example:
#
# #TSI_CANCEL_RESERVATION
# #TSI_RESERVATION_REFERENCE job.1234
#

sub cancel_reservation {

    my $njs_command = shift;
    my $reservation_id;
    if ( $njs_command =~ m/#TSI_RESERVATION_REFERENCE (\S+)/ ) {
        $reservation_id = $1;
    }
    debug_report("Cancel reservation: <$reservation_id>");
    failed_report("Resource reservation NOT SUPPORTED by this TSI.");
}

#
#query a reservation: not supported in this dummy module!
#
#arg1: NJS command
#
# The NJS command includes the reservation ID
#
# Example:
#
# #TSI_QUERY_RESERVATION
# #TSI_RESERVATION_REFERENCE job.1234
#

#
# Result:
# The TSI replies with TSI_OK and a line containing the reservation status and the start time.

# Status is one of UNKNOWN, INVALID, WAITING, READY, ACTIVE, FINISHED or OTHER
# Start time is in the ISO 8601 format used in make_reservation() (see above)
#

sub query_reservation {

    my $njs_command = shift;
    my $reservation_id;
    if ( $njs_command =~ m/#TSI_RESERVATION_REFERENCE (\S+)/ ) {
        $reservation_id = $1;
    }
    debug_report("Query reservation: <$reservation_id>");
    failed_report("Resource reservation NOT SUPPORTED by this TSI.");
}

#
#Executes (claims) a reservation request
#
#arg1: reservation id
#arg2: NJS command
#
sub execute_reservation {

    my $res_id      = shift;
    my $njs_command = shift;

    debug_report("Claim reservation with id <$res_id>");

    #simply submit it...
    submit($njs_command);

}
