package Reporting;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK =
  qw(debug_report failed_report ok_report start_report command_report initial_report report_and_die);

use strict;
use Sys::Syslog qw(:DEFAULT setlogsock);

# uses values set in the configuration section ( main::CMD_SOCK, $debug)

#
# Logging subs.
#
# Destination of log entries can be either stdout or
# the NJS (plus syslog before NJS connections made)
#
# More verbose messaging if "debug" set
#

#
# Write a string to the local syslog at the given facility
#
# arg1: syslog facility
# arg2: string to write

sub syslog_report {
    my $facility = shift;
    my $msg      = shift;
    my $string   = $main::logformat;

    # format log message
    $string =~ s/%m/$msg/;
    if ( $string =~ /%u/ ) {
        my $username = getpwuid($<);
        $string =~ s/%u/$username/;
    }

    setlogsock('unix');

    # configure the remote syslog host if specified
    if ( $main::loghost ne "" ) {
        setlogsock( "udp", $main::loghost );
    }
    openlog( "unicore-tsi", 'pid', $main::logfacility );
    syslog( $facility, $string );
    closelog();
}

# Write a string to the current output with a time stamp (internal)
#
# arg1: string to write

sub report {

    my $time   = scalar localtime;
    my $string = shift;

    $string =~ s/\s+$//;
    initial_report($string);
    print main::CMD_SOCK "TSI_COMMENT\n$time $string\nEND_TSI_COMMENT\n";
}

#
# Write debug information to current output (if debug requested)
#
# arg1: string to write
#
sub debug_report {
    if ($main::debug) {
        my $string = shift;
        report("$string");
    }
}

#
# Execution of an NJS request failed, tell NJS with appropriate protocol
# and also write the message to current output
#
# arg1: failure message
#
sub failed_report {

    my $string = shift;

    # NJS expects a single line, remove any embedded new lines
    $string =~ s/\n/:/g;

    report("Command execution FAILED: $string");
    if ($Reporting::reported_command) {
        report("Command was: $Reporting::reported_command");
        $Reporting::reported_command="";
    }

    # Tell NJS
    print main::CMD_SOCK "TSI_FAILED: $string\n";

}

#
# Execution of an NJS request executed OK, tell NJS with appropriate protocol,
# and also write the message to current output (if debugging)
#
# arg1: debug message
#
sub ok_report {

    my $string = shift;

    debug_report("Command executed OK: $string");

    # Tell NJS
    print main::CMD_SOCK "TSI_OK\n";

}

#
# Start of execution of a request from NJS, write to current output
#
# arg1: message
#
sub start_report {
    my $string = shift;
    report("$string");
}

#
# This is the command that was executed, report if debugging
# record for possible printing by a failed command
#
# arg1: the executed command
#
sub command_report {
    $Reporting::reported_command = shift;   # keep this for use by failed_report
    debug_report("Command is: $Reporting::reported_command");
}

#
# write a string with timestamp to the current output
#
# arg1: message to write
#
sub initial_report {

    my $string = shift;
    my $time   = scalar localtime;
    if ( $main::logdir eq "syslog" ) {
        syslog_report( 'info', $string );
    }
    else {
        print "$time [$$] $string\n";
    }
}

#
# Something has happened to make this execution
# die (assumed that NJS has gone so will log to
# syslog). Should not ever be called.
#
# arg1: message to write
#
sub report_and_die {
    my $string = shift;
    initial_report($string);
    exit 1;
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
