package PutFiles;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(put_files);

use Reporting
  qw(start_report failed_report ok_report debug_report report_and_die);
use Dump2File qw(dump2file);

use strict;

#
# Write files sent by the NJS
#
# Called in response to a TSI_PUTFILES request from the NJS
#
# arg1: none
#
# returns: void to TSI
#
#          takes over NJS-TSI protocol to receive files.
#
#
# (writes to the NJS COMMAND and DATA sockets)
#

sub put_files {

    my $output;
    my $file_name;
    my $packet_length;
    my $left;
    my $offset;
    my $len;
    my $bytes;
    my $written;
    my $action;
    my $from_njs = shift;

    # track write errors. If an error occurs, drain the data channel, 
    # but do not attempt any further writes. Report reason back to NJS
    my $write_error=0;
    my $write_error_message="";

    start_report("Receiving files.");

    # Extract the word following the marker
    ($action) = ( $from_njs =~ /.*#TSI_FILESACTION (.+)\n/ );
    $action = 1 unless length $action;    # default to new only for old NJSs

    # OK, ready to go into mode to accept files and data
    print main::CMD_SOCK "TSI_OK\n";
    print main::CMD_SOCK "ENDOFMESSAGE\n";

    # Read the file name and mode
    $file_name = <main::CMD_SOCK>;
    chomp $file_name;                     # gets rid of ENFOFMESSAGE
    $file_name =~ s/\n.*//g;    # keep only first line and without new line char
    my $mode;

    my $mode_pos = rindex( $file_name, " " );
    $mode = substr( $file_name, $mode_pos + 1, length($file_name) );
    $file_name = substr( $file_name, 0, $mode_pos );

    while ( $file_name ne "-1" ) {

        dump2file($file_name);

        $file_name =~ s/\$USER/$ENV{USER}/g;
        $file_name =~ s/\$HOME/$ENV{HOME}/g;

        # Untaint (I trust the source)
        if ( $file_name =~ m/(.*)/s ) {
            $file_name = $1;
        }

        if ( $mode =~ m/(.*)/s ) {
            $mode = $1;
        }

        # What do we do about existing files?
        # 0, not processed so overwrites existing (is sent by NJS)
        # 1 => Do not overwrite existing
        # 2 => File must exist (not used by NJS Sept 03)
        # 3 => Append (new Sept 03)
        if ( -e $file_name ) {
            if ( $action == 1 ) {
                failed_report("File already exists: $file_name\n");
                return;
            }
        }
        else {
            if ( $action == 2 ) {
                failed_report("File does not exist: $file_name\n");
                return;
            }
        }

        # Open the file
        if ( $action == 3 ) {
            if ( !open( OUTF, ">>$file_name" ) ) {
                failed_report(
                    "Putfiles cannot open the file for appending: $file_name.");
                return;
            }
        }
        else {
            if ( !open( OUTF, ">$file_name" ) ) {
                failed_report(
                    "Putfiles cannot open the file for writing: $file_name.");
                return;
            }
        }

        # Put NJS into send mode for next command
        print main::CMD_SOCK "TSI_OK\nENDOFMESSAGE\n";

        # Read packet length
        $packet_length = <main::CMD_SOCK>;
        chomp $packet_length;   # gets rid of ENFOFMESSAGE
        # keep only first line and without new line char
        $packet_length =~ s/\n.*//g;

        # Put NJS into send mode for next command
        print main::CMD_SOCK "TSI_OK\nENDOFMESSAGE\n";    

        # Read data
        while ( $packet_length > -1 ) {

            # No EOF in DATA stream, so have to count bytes
            $left = $packet_length;
            while ( $left >= $main::BUFFER_SIZE ) {

                $len = read main::DATA_SOCK, $bytes, $main::BUFFER_SIZE;
                $left -= $len;
                $offset = 0;
                while ($len>0) { # Handle partial writes
                    $written = syswrite OUTF, $bytes, $len, $offset;
                    if ($write_error==0) {
                        if (defined $written) {
                            $len -= $written;
                            $offset += $written;
                        }
                        else{
                            $write_error_message="Putfiles has fatal write error: $!"; 
                            $write_error=1;
                            $len=0;
                        }
		    }
                    else{
                        $len=0; # assume write was completed
                    }
                }
            }
            if ( $left > 0 ) {
                $len = read main::DATA_SOCK, $bytes, $left;
                $offset = 0;
                while ($len>0 and $write_error==0) {
                    $written = syswrite OUTF, $bytes, $len, $offset;
                    if (defined $written) {
                        $len -= $written;
                        $offset += $written;
                    }
                    else {
                        $write_error_message="Putfiles has fatal write error: $!";
                        $write_error=1;
                        $len=0;
                    }
                }
            }
            if ($write_error==0) {
                # Read next packet length
                $packet_length = <main::CMD_SOCK>;
                chomp $packet_length;        # gets rid of ENFOFMESSAGE
                # keep only first line and without new line char
                $packet_length =~ s/\n.*//g;    
                # Put NJS into send mode for next command
                print main::CMD_SOCK "TSI_OK\nENDOFMESSAGE\n";
            }
            else{
                # Read next packet length from cmd to satisfy protocol
                $packet_length  = <main::CMD_SOCK>;
                $packet_length  = "-1"; # but we won't use it
                failed_report($write_error_message);
                return;
            }
        }

        close(OUTF);

  # For backwards compatibility: old (pre 6.4.2) XNJS sends only the owner perms,
  # so we have to move them left two (octal) places. Newer XNJS sends full perms.
        if ( length($mode) == 1 ) {
            $mode = $mode * 64;    # that is $mode00 in octal
        }
        else {
            $mode = oct($mode);
        }

        # only chmod if not appending!
        if($action != 3){
            chmod $mode, $file_name;
        }

        # Read the next file name
        $file_name = <main::CMD_SOCK>;
        chomp $file_name;    # gets rid of ENFOFMESSAGE
        # keep only first line and without new line char
        $file_name =~ s/\n.*//g;

        ( $file_name, $mode ) = split " ", $file_name;

    }

    ok_report("Putfiles finished executing OK");
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
