package Initialisation;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(initialisation);

use Socket;
use Reporting qw(initial_report report_and_die);

use IO::Socket;

use strict;

sub GENTLY {
    initial_report("TSI Shepherd requested to finish (SIGTERM)");
    close(FROM_NJS);
    exit(0);
}

sub initialisation() {

    $SIG{CHLD} = 'IGNORE';
    $SIG{TERM} = \&GENTLY;

    initial_report("TSI $main::my_version for $main::my_os ");
    initial_report(
        "Copyright (c) Fujitsu Ltd, 1999 to 2003. All Rights Reserved.");
    initial_report("Using Perl version $]");

    # --------------------------------------------------------------------
    # Where to contact the NJS. This information can come
    # from the command line (two arguments in order host_name, port)
    # or, failing that, from values in the initialisation section.
    #
    # The NJS is told about TSIs in the IDB TSI description section
    # with the keyword PORT.

    my $njs_machine = $main::njs_machine;
    if ( $njs_machine =~ m/(.*)/s ) {
        $njs_machine = $1;
    }

    my @machines = split( /,/, $njs_machine );
    my @njs_addresses;

    for my $machine (@machines) {
        my $iaddr      = inet_aton($machine);
        my $ip_address = inet_ntoa($iaddr);
        initial_report("Defined NJS machine: $machine $ip_address");
        push @njs_addresses, $ip_address;
    }

    my $njs_port;

    # NJS port is now optional, if it isn't specified or
    # invalid, it will be read on the socket from the NJS
    if ( defined $main::njs_port ) {
        $njs_port = $main::njs_port;
        if ( $njs_port =~ m/(.*)/s ) {
            $njs_port = $1;
        }
    }

    my $my_port = $main::my_port;
    if ( $my_port =~ m/(.*)/s ) {
        $my_port = $1;
    }

    my $proto = getprotobyname('tcp');
    my $paddr;

    my $old_fh = select(STDOUT);
    $| = 1;
    select($old_fh);

    $old_fh = select(STDERR);
    $|      = 1;
    select($old_fh);

    # Open a server socket to listen for new TSI requests from the NJS
    my $FROM_NJS;
    initial_report("Opening TSI port $my_port");
    if ( defined $main::ssl ) {

        initial_report("Requiring SSL connection from XNJS");
        eval "use IO::Socket::SSL";    #load SSL module at runtime
        die "couldn't load module IO::Socket:SSL : $! \n" if ($@);

        # If using SSL connections
        if (
            !(
                $FROM_NJS = IO::Socket::SSL->new(
                    Listen          => SOMAXCONN,
                    LocalPort       => $my_port,
                    Proto           => 'tcp',
                    ReuseAddr       => 1,
                    SSL_use_cert    => 1,
                    SSL_verify_mode => 0x01,
                    SSL_key_file    => $main::keystore,
                    SSL_cert_file   => $main::keystore,
                    SSL_ca_file     => $main::truststore,
                    SSL_passwd_cb   => sub { $main::keypass },
                )
            )
          )
        {
            warn "unable to create socket: ", &IO::Socket::SSL::errstr, "\n";
            exit(1);
        }
    }
    else {

        # If using CLASSIC connections
        # Use of IO::Socket instead of classic socket API
        # in order to unify the use of SSL and plain Socket
        # the main changes in the code are that FROM_NJS is now
        # used as a reference to a filehandle and not directly as
        # a filehandle.
        if (
            !(
                $FROM_NJS = IO::Socket::INET->new(
                    Listen    => SOMAXCONN,
                    LocalPort => $my_port,
                    Proto     => 'tcp',
                    ReuseAddr => 1,
                )
            )
          )
        {
            warn "unable to create socket: $@ \n";
            exit(1);
        }
    }

    my ( $other_end, $other_iaddr, $other_port, $pid, $other_ip_address,
        $this_njs_port );
    my $NJS_CLIENT;

# Using $FROM_NJS->accept() works with both IO::Socket and IO::Socket::SSL sockets
    while ( $NJS_CLIENT = $FROM_NJS->accept() ) {
        if ( defined $main::ssl
            && !cert_is_trusted( $NJS_CLIENT, $main::truststore ) )
        {

            # if the peer cert isn't in the truststore,
            # close the Socket and go back to accept
            initial_report("NJS is using an untrusted certificate");
            $NJS_CLIENT->close();
            next;
        }

        # Got connection, from NJS?
        if ( $other_end = getpeername($NJS_CLIENT) ) {
            ( $other_port, $other_iaddr ) = unpack_sockaddr_in($other_end);
            $other_ip_address = inet_ntoa($other_iaddr);
            if (
                defined $main::ssl
                || connection_from_njs_machine(
                    $other_ip_address, @njs_addresses
                )
              )
            {

                #Read message from NJS to see if we need to go
                my $message = <$NJS_CLIENT>;
                $message =~ /get down shep\n/ && do {
                    initial_report("NJS requested a stop");
                    GENTLY();
                };

                # if $njs_port is set and is number, use it
                if ( $njs_port =~ /\D/ ) {
                    initial_report(
                        "NJS port undefined, will read it from the NJS message"
                    );
                }
                else { $this_njs_port = $njs_port }

                if ( !$this_njs_port ) {

                    # if $this_njs_port not set, try to read it from the NJS
                    $message =~ /^\w+\s(\w+)/;
                    $this_njs_port = $1;

                    # if NJS sends a name, try to get port with /etc/services
                    if ( $this_njs_port =~ /\D/ ) {
                        $this_njs_port = getservbyname( $this_njs_port, 'tcp' );
                    }
                    die("No NJS port\n") unless $this_njs_port;
                }

                # Write anything to tell NJS that this is OK
                $old_fh = select($NJS_CLIENT);
                $|      = 1;
                select($old_fh);
                print $NJS_CLIENT "OK\n";
                close($NJS_CLIENT);

          # --------------------------------------------------------------------
          # Open a pair of sockets to the NJS, one to carry commands (text)
          # and the other to carry data (files read and written).

                initial_report(
"Contacting the NJS on <$other_ip_address> at port number <$this_njs_port>"
                );
                if ( defined $main::ssl ) {
                    $main::CMD_SSL = IO::Socket::SSL->new(
                        PeerAddr        => $other_ip_address,
                        PeerPort        => $this_njs_port,
                        Proto           => 'tcp',
                        SSL_use_cert    => 1,
                        SSL_verify_mode => 0x01,
                        SSL_key_file    => $main::keystore,
                        SSL_cert_file   => $main::keystore,
                        SSL_ca_file     => $main::truststore,
                        SSL_passwd_cb   => sub { $main::keypass },
                      )
                      || report_and_die( "unable to create SSL command socket: "
                          . &IO::Socket::SSL::errstr
                          . "\n" );

                    $main::DATA_SSL = IO::Socket::SSL->new(
                        PeerAddr        => $other_ip_address,
                        PeerPort        => $this_njs_port,
                        Proto           => 'tcp',
                        SSL_use_cert    => 1,
                        SSL_verify_mode => 0x01,
                        SSL_key_file    => $main::keystore,
                        SSL_cert_file   => $main::keystore,
                        SSL_ca_file     => $main::truststore,
                        SSL_passwd_cb   => sub { $main::keypass },
                      )
                      || report_and_die( "unable to create SSL data socket: "
                          . &IO::Socket::SSL::errstr
                          . "\n" );

                    # Ensure that output is flushed
                    $old_fh = select($main::CMD_SSL);
                    $|      = 1;
                    select($old_fh);

                    $old_fh = select($main::DATA_SSL);
                    $|      = 1;
                    select($old_fh);

                }
                else {

           # Open the commands channel, wait here for the NJS to start listening
                    $paddr = sockaddr_in( $this_njs_port, $other_iaddr );
                    socket( main::CMD_SOCK, PF_INET, SOCK_STREAM, $proto )
                      or report_and_die("command socket: $!");
                    while ( !connect( main::CMD_SOCK, $paddr ) ) {
                        initial_report(
"Waiting for NJS at $other_ip_address:$this_njs_port to come up (last connect attempt said: $!)"
                        );
                        sleep 3;
                        socket( main::CMD_SOCK, PF_INET, SOCK_STREAM, $proto )
                          or report_and_die("command socket: $!");
                    }

                    # Open the data channel
                    socket( main::DATA_SOCK, PF_INET, SOCK_STREAM, $proto )
                      or report_and_die("data socket: $!");
                    connect( main::DATA_SOCK, $paddr )
                      or report_and_die("data connect: $!");

                    # Ensure that output is flushed
                    $old_fh = select(main::CMD_SOCK);
                    $|      = 1;
                    select($old_fh);

                    $old_fh = select(main::DATA_SOCK);
                    $|      = 1;
                    select($old_fh);

                }

                initial_report(
"Connection to NJS at $other_ip_address:$this_njs_port established."
                );

          # --------------------------------------------------------------------
          # Now fork the child which becomes the requested TSI
                if ( $pid = fork ) {

                    # Parent, do not want the NJS sockets
                    if ( defined $main::ssl ) {

                    # close Socket but keep the SSL session opened for the child
                        $main::CMD_SSL->close( SSL_no_shutdown => 1 );
                        $main::DATA_SSL->close( SSL_no_shutdown => 1 );
                    }
                    else {
                        close(main::CMD_SOCK);
                        close(main::DATA_SOCK);
                    }
                    next;    # go back to accept

                }
                elsif ( defined $pid ) {    # $pid is actually 0 in child
                        # Child, do not want the listener to NJS connections
                    close(FROM_NJS);

                    if ( defined $main::ssl ) {

                        # this lines translate reference to sockets into
                        # typeglobs as they are used in the rest of the code
                        *main::CMD_SOCK  = $main::CMD_SSL;
                        *main::DATA_SOCK = $main::DATA_SSL;
                    }

                    # Clear the signal handlers, CHLD screws script execution
                    $SIG{CHLD} = 'DEFAULT';
                    $SIG{TERM} = 'DEFAULT';

         #
         # Reset some variables that must be unique amongst all TSIs
         # Do it here so that sites don't have to redo changes made to Submit.pm
         #
         # the "eval" should trap errors in TSIs that do not use the
         # particular variable
         #
                    eval {
                        $Submit::counter = $$ * 100   # For versions without BSS
                    };
                    eval {
                        $Submit::tsi_unique_file_name =
                          "TSI_temp_file_$$"          # for all other TSIs
                    };

                    return
                      ;   # <---- Back to tsi and so to the main processing loop
                }
                else {

                    # Fork failed, NJS will eventually notice that worker will
                    # not contact and retry so as for parent
                    close(main::CMD_SOCK);
                    close(main::DATA_SOCK);
                    next;
                }
            }
            else {

                # IP addresses differ, ignore
                close($NJS_CLIENT);
                initial_report(
"The other end of a start TSI request does not come from the NJS, ignoring: $other_ip_address"
                );
            }
        }
        else {
            close($NJS_CLIENT);
            initial_report(
                "Could not identify other end of a start TSI request, ignoring."
            );
        }
    }

    # Should never never get here ......
    die "Failed while listening for NJS connections: $!\n";

}

sub cert_is_trusted {
    my ( $sock, $trustfile ) = @_;

    # get an IO::Socket::SSL and a PEM file
    # return 1 if the peer certificate is present in the PEM file.

    my $cert = $sock->peer_certificate();
    my $peer = Net::SSLeay::PEM_get_string_X509($cert);

    open( F, $trustfile );
    my $trusted;

    # check if the peer certificate is in the truststore
    while (<F>) {
        $trusted = q{}
          if (/BEGIN CERTIFICATE/)
          ;    # reset $trusted string if a new certificate begin
        $trusted .= $_
          if ( /BEGIN CERTIFICATE/ .. /END CERTIFICATE/ )
          ;    # copy the new certificate in $trusted
        close F && return 1
          if ( /END CERTIFICATE/ && $peer eq $trusted )
          ;    # when the trusted cert is read, return 1 if they match
    }
    close F;
    return 0;
}

#
# checks whether the connection is from one of the allowed NJS hosts
#
# params:
#  0: ip address of the other end
#  1: array of allowed NJS IP addresses
#
sub connection_from_njs_machine {
    my $requestor = shift;
    for my $addr (@_) {
        return 1 if ( $addr eq $requestor );
    }
    return 0;
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
