package GetFileChunk;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_file_chunk);

use Reporting
  qw(start_report failed_report ok_report debug_report report_and_die);

use strict;

# Writes to the NJS COMMAND and DATA sockets

# Return part of a file to the NJS
#
# Called in response to a TSI_GETFILECHUNK request from the NJS
#
# arg1: text sent by the NJS. this is processed for:
#           TSI_FILE   - file to return
#           TSI_START  - start byte
#           TSI_LENGTH - how many bytes to return
#
# returns: void to TSI
#
#          takes over NJS-TSI protocol to send files.
#
#
sub get_file_chunk {

    my $from_njs = shift;

    my $file;
    my $start;
    my $length;

    ($file)   = ( $from_njs =~ /.*#TSI_FILE (.+)\n/ );
    ($start)  = ( $from_njs =~ /.*#TSI_START (.+)\n/ );
    ($length) = ( $from_njs =~ /.*#TSI_LENGTH (.+)\n/ );

    $file =~ s/\$USER/$ENV{USER}/g;
    $file =~ s/\$HOME/$ENV{HOME}/g;

    debug_report("Returning expanded file name: $file\n");

    if ( !open( FILE, "<$file" ) ) {
        failed_report("File cannot be opened: $file");
        return;
    }

    if ( -p $file ) {

        # This is a fifo, don't skip initial bytes (ignore start)
        debug_report("Reading a fifo: $file $length\n");
    }
    else {
        debug_report("Reading a file: $file $start $length\n");
        if ( !sysseek( FILE, $start, 0 ) ) {
            failed_report("Cannot skip to $start in $file");
            close(FILE);
            return;
        }
    }

    my $buf;
    my $offset  = 0;
    my $message = "TSI_OK";

    # Read in the requested number of bytes
    while ( $length > 0 ) {
        my $read = sysread FILE, $buf, $length, $offset;
        if ( !defined $read ) {
            $message = "TSI_FAILED: Problems reading file";
            last;
        }
        if ( $read == 0 ) {
            if ( -p $file ) {
                $message = "TSI_OK: FIFO EOF";
            }
            else {
                $message =
"TSI_FAILED: Unexpectedly at end of file (got $offset, still need $length) $file $start";
            }
            last;
        }

        $length = $length - $read;
        $offset = $offset + $read;
    }
    close(FILE);
    print main::CMD_SOCK "$message\nTSI_LENGTH $offset\n";
    print main::CMD_SOCK "ENDOFMESSAGE\n";

    my $woffset = 0;

    my $written;
    while ($offset) {    # handling partial writes
        $written = syswrite main::DATA_SOCK, $buf, $offset, $woffset;
        report_and_die("Portfolio copy error writing to NJS: $!")
          unless defined $written;
        $offset -= $written;
        $woffset += $written;
    }

}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
