package ExecuteScript;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(execute_script);

use Reporting qw(debug_report failed_report ok_report);

use strict;

# Executes a script from the NJS "interactively"
#
# Called in response to a #TSI_EXECUTESCRIPT string found in the
# NJS message.
#
#
# arg 1 = Script to execute
#
# Returns void to TSI
#
#  success/failure to NJS
#
# if the NJS message includes a line
#
#  #TSI_DISCARD_OUTPUT=true
#
# the output of the user script is discarded.
# Otherwise the output is captured and
# returned to the NJS
#
sub execute_script {

    my $script = shift;

    my $discard = "";

    $_ = $script;

    while (/#TSI_(\S+) (.*)\n/g) {
        $discard = $2 if $1 eq "DISCARD_OUTPUT";
    }

    # Substitute common environment values

    $script =~ s/\$USER/$ENV{USER}/g;
    $script =~ s/\$HOME/$ENV{HOME}/g;

    debug_report("Executing a script: $script");

    my $output = "";

    if ( $discard eq "true" ) {
        system($script);
    }
    else {
        $output = `($script) 2>&1`;
    }

    if ( $? != 0 ) {
        failed_report("$? $! $output");
    }
    else {
        ok_report($output);
        print main::CMD_SOCK $output;
        print main::CMD_SOCK "\n";
    }
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
