package Dump2File;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(dump2file);

use strict;

BEGIN {
    $Dump2File::dumper = 1;    # Order dump files sequentially
}

# uses values set in the configuration section ($main::dump_messages);

#
# Dump value to file
#
sub dump2file {
    if ($main::dump_messages) {
        my $bytes  = shift;
        my $len    = length($bytes);
        my @tima   = localtime;
        my $s      = $tima[0];
        my $m      = $tima[1];
        my $h      = $tima[2];
        my $D      = $tima[3];
        my $M      = $tima[4] + 1;
        my $Y      = $tima[5] + 1900;
        my $suffix = sprintf( "%5d.%2d-%2d-%2d_%2d:%2d:%2d_%4d",
            $$, $Y, $M, $D, $h, $m, $s, $Dump2File::dumper );
        $suffix =~ s/\s/0/g;

#my $dump_file = "$main::dump_dir/$ENV{USER}.$suffix"; # Perl complains that ENV is insecure
        my $dump_file = "$main::dump_dir/TSI_DUMP.$suffix";
        $Dump2File::dumper++;

        open( DUMP, ">$dump_file" );
        my $offset = 0;    # See Programming Perl p231
        while ($len) {     # Handle partial writes
            my $written = syswrite DUMP, $bytes, $len, $offset;
            if ( !defined $written ) {
                print "DUMP write error ($len bytes) to file $dump_file: $!\n";
                last;
            }              # unless defined $written;
            $len -= $written;
            $offset += $written;
        }
        close(DUMP);
    }
}

#
# Code from Klaus-Dieter Oertel (Pallas)
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
