package CommonUtils;

require Exporter;
@ISA       = qw(Exporter);
@EXPORT_OK = qw(addperms);
use strict;

# This file contains utility functions used by other TSI rutines.

# Expects two arguments: octal mode and file name. The function
# will *add* the mode permissions to those which are already set for the file.
# Note: there is File::chmod for this but as this module is non-standard we reimplement
# here a small subset of its functionality.
sub addperms {
    my $mode = shift;
    my $path = shift;

    my (
        $dev,  $ino,   $curmode, $nlink, $uid,     $gid, $rdev,
        $size, $atime, $mtime,   $ctime, $blksize, $blocks
    ) = stat($path);
    $mode = $curmode | $mode;
    chmod( $mode, $path );
}
