package NoBatchOnly;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_target_pid add_zombie reap_zombies);

use Reporting qw(failed_report command_report);

use strict;

# get definition of WNOHANG
use POSIX ":sys_wait_h";

# declare hash table and counter for zombie processes
BEGIN {
    %NoBatchOnly::zombies           = ();
    $NoBatchOnly::number_of_zombies = 0;
}

# add child process (a potential zombie) to zombie hash table
# and increase counter
sub add_zombie {
    my $pid = shift;
    $NoBatchOnly::zombies{$pid} = $pid;
    $NoBatchOnly::number_of_zombies++;

    #print_zombies("added ZOMBIE $pid");
}

# reap all zombies in hash table
sub reap_zombies {
    my $zombie;
    my $pid;
    my $ztatus;
    foreach $zombie ( keys %NoBatchOnly::zombies ) {
        $pid = waitpid( $zombie, &WNOHANG );
        $ztatus = $?;

#print "$$ ZOMBIE: WAITPID returned $pid (status $ztatus) for zombie $zombie\n";
        if ( $pid == -1 ) {

            #print "$$ ZOMBIE: DELETING $zombie from hash\n";
            delete $NoBatchOnly::zombies{$zombie};
            $NoBatchOnly::number_of_zombies--;
        }
        else {
            $NoBatchOnly::zombies{$zombie} = $pid;
        }
    }

    #print_zombies("reaped ZOMBIEs");
}

# print zombie hash table
sub print_zombies {
    my $info = shift;
    my $zombie;
    my $nzombie = scalar( keys %NoBatchOnly::zombies );
    if ( $nzombie != $NoBatchOnly::number_of_zombies ) {
        print
"\n$$ ZOMBIE error in counting: nzombie=$nzombie != $NoBatchOnly::number_of_zombies=number_of_zombies\n\n";

    }
    print
"$$ =============== print ZOMBIES ($nzombie elements) after $info ===================\n";
    foreach $zombie ( keys %NoBatchOnly::zombies ) {
        print
          "$$ ZOMBIE hash: key $zombie value $NoBatchOnly::zombies{$zombie}\n";
    }
    print "$$ %%%%%%%%%%%%%%% printed ZOMBIES %%%%%%%%%%%%%%%%%%%\n";
}

#
# Get the actual process id for a Unicore "job" being
# executed by this TSI
#
# arg1: the Unicore identifier of the job (-1 on failure -
#       which includes job not found)
#
# return: the process id
#
sub get_target_pid {

    my $unicoreid = shift;

    my $target_pid = -1;

    # Cannot know child id when starting execution of the Unicore job
    # so the NJS returns a generated value
    # we now need to convert this value into a real pid. At the moment by doing
    # a ps and processing (sometime by writing to a file in the child?)

    my $command = "$main::pspid_cmd";

    command_report($command);

    my $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
        return;
    }
    else {

        my @lines = split /\n/, $output;
        my $pid;
        my $bssid;
        my $junk;

        for (@lines) {

          SWITCH: {

                /UNICORE/ && do {

                    # Found a job running for Unicore
                    s/^\s+//;    # remove leading spaces for short pids
                    ( $pid, $junk ) = split / /, $_;

                    # Perl passes command line through "sh -c" to
                    # interpret the commands which results in two processes
                    # matching. Use the one that is executing the command

                    if ( !( $_ =~ /sh -c/ ) ) {

                        ( $junk, $bssid, $junk ) = split /_/, $_;

                        # Is it a Unicore job?
                        if ( !( $bssid eq "" ) ) {

                            # Is it the target?
                            if ( $bssid == $unicoreid ) {

                                # untaint the data
                                $pid =~ /(\d+)/;
                                $target_pid = $1;
                            }
                        }
                    }

                    last SWITCH;
                  }

            }
        }

    }

    return $target_pid;
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
