package JobControl;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(abort_job cancel_job hold_job resume_job get_job_details);

use Reporting qw(start_report failed_report ok_report command_report);

use NoBatchOnly qw(get_target_pid);

use strict;

# Emulation of BSS job control functions

# Abort a job on the BSS.
#
# arg1: text from NJS with TSI_BSSID <request id>
#
sub abort_job {

    my $from_njs = shift;

    my ( $requestid, $output, $command, $target_pid );

    ($requestid) = ( $from_njs =~ /.*#TSI_BSSID (.+)\n/ );

    start_report("Aborting request $requestid");

    $target_pid = get_target_pid($requestid);

    if ( $target_pid == -1 ) {
        failed_report("Target job not found");
        return;
    }

    # Ensure that $target_pid is a number
    $target_pid =~ /(\d+)/;
    $command = "pkill -9 -P $1";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {
        ok_report($output);
    }
}

# Cancel a job on the BSS (abort plus dispose of output files)
#
# arg1: text from NJS with TSI_BSSID <request id>
#
sub cancel_job {

    my $from_njs = shift;

    my ( $requestid, $output, $command, $target_pid );

    ($requestid) = ( $from_njs =~ /.*#TSI_BSSID (.+)\n/ );

    start_report("Cancelling request $requestid");

    $target_pid = get_target_pid($requestid);

    if ( $target_pid == -1 ) {
        failed_report("Target job not found");
        return;
    }

    $command = "pkill -9 -P $target_pid\n";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {
        ok_report($output);
    }
}

# Hold a job on the BSS.
#
# arg1: text from NJS with TSI_BSSID <request id>
#
sub hold_job {
    $_ = shift;
    if (/#TSI_FREEZE/) {
        ok_report("No freezing of jobs on this TSI (no Batch sub-system)");
    }
    else {
        ok_report("No holding of jobs on this TSI (no Batch sub-system)");
    }
}

# Resume a job on the BSS.
#
# arg1: text from NJS with TSI_BSSID <request id>
#
sub resume_job {
    ok_report("No resuming holding of jobs on this TSI (no Batch sub-system)");
}

# 
# Job details, not possible for no-batch
#
sub get_job_details {
    ok_report("");
    print main::CMD_SOCK "No further information is available.\n";
}


#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
