package GetStatusListing;    # SPECIALISATION WITHOUT BATCH SUB-SYSTEM

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting
  qw(start_report failed_report ok_report debug_report command_report);

use strict;

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my (
        $command, $output, $result, $bssid,
        $bssid,   $state, $ustate
    );

    debug_report("Finding all jobs from Unicore");

    # Form the request command.
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if ( $? != 0 ) {
        failed_report($output);
    }
    else {

        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its _Unicore_ state

        # There can be many TSIs running, return about all Jobs

        $result = "QSTAT\n";
        $_      = $output;

        while ( /^(\w) (.*)UNICORE_(\d+).*/gm )
        {
            # Found a job running for Unicore
            $state=$1;
            $bssid=$3;

            $ustate = "UNKNOWN";
            $ustate = "RUNNING" if $state =~ /O|R|S/;
            $ustate = "SUSPENDED" if $state =~ /T/;

#            if ( $bssid ne "" ) {
                $result = "$result $bssid $ustate\n";
#            }
        }

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK\n$result");
    }
}

#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
