/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix.metrics;

import de.fzj.unicore.metrix.AbstractMetric;
import de.fzj.unicore.metrix.MetricValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfo
extends AbstractMetric<String> {
    public SystemInfo() {
        super("system.vm.overview", "system");
    }

    @Override
    protected MetricValue doGetValue() {
        MetricValue mv = new MetricValue(this.getName(), this.getResult(), this.getMetricUnit(), System.currentTimeMillis());
        return mv;
    }

    protected void doPush(String ... data) {
    }

    @Override
    public String getMetricUnit() {
        return "n/a";
    }

    @Override
    public String getResult() {
        StringBuilder sb = new StringBuilder();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        sb.append("Memory: ").append(free).append("/").append(total).append(" MB.");
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        sb.append(" ");
        Thread[] tList = new Thread[1000];
        int num = parent.enumerate(tList);
        sb.append("Threads: ");
        if (num == tList.length) {
            sb.append(">");
        }
        tList = null;
        sb.append(num);
        return sb.toString();
    }
}

