/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix.metrics;

import de.fzj.unicore.metrix.AbstractMetric;
import de.fzj.unicore.metrix.MetricValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanFloatValue
extends AbstractMetric<Float> {
    float result;
    int number;
    private final String units;

    public MeanFloatValue(String name, String units, String ... categories) {
        super(name, categories);
        this.units = units;
    }

    @Override
    public String getMetricUnit() {
        return this.units;
    }

    @Override
    public Float getResult() {
        return Float.valueOf(this.result);
    }

    @Override
    protected MetricValue doGetValue() {
        return new MetricValue(this, Float.valueOf(this.result));
    }

    protected void doPush(Float ... data) {
        Float[] floatArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Float o = floatArray[n2];
            this.update(o);
            ++n2;
        }
    }

    private synchronized void update(Float l) {
        this.result = (this.result * (float)this.number + l.floatValue()) / (float)(this.number + 1);
        ++this.number;
    }

    public int getNumberOfDataPoints() {
        return this.number;
    }

    @Override
    public synchronized void clearData() {
        this.number = 0;
        this.result = 0.0f;
    }
}

