/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix.metrics;

import de.fzj.unicore.metrix.AbstractMetric;
import de.fzj.unicore.metrix.MetricValue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
extends AbstractMetric<Float> {
    float result = -1.0f;
    AtomicInteger number = new AtomicInteger(0);
    private final String units;
    private final int windowSize;
    private long lastSampleIntervalStartTime;

    public Frequency(String name, int windowSize, String units, String ... categories) {
        super(name, categories);
        this.windowSize = windowSize;
        this.units = units;
        this.lastSampleIntervalStartTime = System.currentTimeMillis();
    }

    public Frequency(String name, String units, String ... categories) {
        this(name, 5, units, categories);
    }

    @Override
    public String getMetricUnit() {
        return this.units;
    }

    @Override
    public Float getResult() {
        return Float.valueOf(this.result);
    }

    @Override
    protected MetricValue doGetValue() {
        this.update();
        return new MetricValue(this, Float.valueOf(this.result));
    }

    protected void doPush(Float ... data) {
        this.number.incrementAndGet();
    }

    private synchronized void update() {
        long currentInterval = System.currentTimeMillis() - this.lastSampleIntervalStartTime;
        this.result = 1000.0f * Float.valueOf(this.number.get()).floatValue() / (float)currentInterval;
        if (currentInterval > (long)(1000 * this.windowSize)) {
            this.lastSampleIntervalStartTime = System.currentTimeMillis();
            this.number.set(0);
        }
    }

    @Override
    public MetricValue getValue() {
        return this.doGetValue();
    }

    public int getNumberOfSamples() {
        return this.number.get();
    }

    public long getCurrentInterval() {
        return System.currentTimeMillis() - this.lastSampleIntervalStartTime;
    }
}

