/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricValue;
import de.fzj.unicore.metrix.messaging.IValueListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category {
    private final String name;
    private final Map<String, IMetric<?>> metrics = new HashMap();
    private final Set<IValueListener> listeners = new HashSet<IValueListener>();

    public Category(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addMetric(String id, IMetric<?> metric) {
        this.metrics.put(id, metric);
    }

    public IMetric<?>[] getMetrics() {
        IMetric[] metricArray = new IMetric[this.metrics.size()];
        this.metrics.values().toArray(metricArray);
        return metricArray;
    }

    public void removeMetric(String metricID) {
        this.metrics.remove(metricID);
    }

    public void removeMetric(IMetric<?> metric) {
        this.metrics.remove(metric.getName());
    }

    public void addListener(IValueListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IValueListener listener) {
        this.listeners.remove(listener);
    }

    public void publish(MetricValue value) {
        for (IValueListener msg : this.listeners) {
            msg.publish(value);
        }
    }
}

