/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.metrix;

import de.fzj.unicore.metrix.Category;
import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricValue;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetric<T>
implements IMetric<T> {
    private Set<String> categoryNames = new HashSet<String>();
    private final String name;
    private volatile boolean isEnabled = true;
    private final Set<Category> categories = new HashSet<Category>();
    protected MetricValue cachedValue;

    public AbstractMetric(String name, String ... categories) {
        this.name = name;
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            this.categoryNames.add(cat);
            ++n2;
        }
    }

    @Override
    public String[] getCategories() {
        return this.categoryNames.toArray(new String[this.categoryNames.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final void push(T ... data) {
        if (this.isEnabled) {
            this.cachedValue = null;
            this.doPush(data);
            this.publishToCategories();
        }
    }

    protected abstract void doPush(T ... var1);

    protected void publishToCategories() {
        MetricValue value = this.getValue();
        for (Category c : this.categories) {
            c.publish(value);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void stop() {
        this.isEnabled = false;
    }

    @Override
    public void start() {
        this.isEnabled = true;
    }

    @Override
    public void registerCategory(Category category) {
        this.categories.add(category);
        this.categoryNames.add(category.getName());
    }

    @Override
    public void clearData() {
    }

    @Override
    public MetricValue getValue() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        this.cachedValue = this.doGetValue();
        return this.cachedValue;
    }

    protected abstract MetricValue doGetValue();
}

