/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.assertion;

import eu.unicore.samly2.assertion.AbstractAssertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.io.IOException;
import java.util.Calendar;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.AuthnContextType;
import xmlbeans.org.oasis.saml2.assertion.AuthnStatementType;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityType;

public class Assertion
extends AbstractAssertion {
    private static final long serialVersionUID = 2694770099055262044L;

    public Assertion() {
    }

    public Assertion(AssertionDocument doc) throws SAMLParseException, XmlException, IOException {
        super(doc);
    }

    public void addAttribute(SAMLAttribute at) {
        if (this.assertion.getAttributeStatementArray() == null || this.assertion.getAttributeStatementArray().length == 0) {
            this.assertion.addNewAttributeStatement();
        }
        AttributeStatementType attrStatement = this.assertion.getAttributeStatementArray(0);
        AttributeType added = attrStatement.addNewAttribute();
        added.set((XmlObject)at.getXBean());
    }

    public void removeAttribute(int num) {
        this.assertion.removeAttributeStatement(num);
    }

    public AttributeStatementType[] getAttributes() {
        return this.assertion.getAttributeStatementArray();
    }

    public void addAuthStatement(Calendar authTime, AuthnContextType ctx, String sessionIdx, Calendar sessionEnd, SubjectLocalityType subjectLocation) {
        if (this.assertion.getAuthnStatementArray() == null || this.assertion.getAuthnStatementArray().length == 0) {
            this.assertion.addNewAuthnStatement();
        }
        AuthnStatementType authStatement = this.assertion.getAuthnStatementArray(0);
        authStatement.setAuthnInstant(authTime);
        authStatement.setAuthnContext(ctx);
        if (sessionIdx != null) {
            authStatement.setSessionIndex(sessionIdx);
        }
        if (sessionEnd != null) {
            authStatement.setSessionNotOnOrAfter(sessionEnd);
        }
        if (subjectLocation != null) {
            authStatement.setSubjectLocality(subjectLocation);
        }
    }

    public void addAuthStatement(Calendar authTime, AuthnContextType ctx) {
        this.addAuthStatement(authTime, ctx, null, null, null);
    }

    public AuthnStatementType[] getAuthStatements() {
        return this.assertion.getAuthnStatementArray();
    }
}

