/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.herasaf.xacml.core.types.YearMonthDuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date
implements Comparable<Date> {
    private XMLGregorianCalendar xmlCalendar;
    private static final String PATTERNSTRING = "\\d\\d\\d(\\d)+-\\d\\d-\\d\\d((\\+|-)\\d\\d:\\d\\d)?";

    public Date(String lexicalRepresentation) {
        if (!lexicalRepresentation.matches(PATTERNSTRING)) {
            throw new IllegalArgumentException("The format of the argument: \"" + lexicalRepresentation + "\" isn't correct");
        }
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            this.xmlCalendar = factory.newXMLGregorianCalendar(lexicalRepresentation);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XMLGregorianCalendar getCalendar() {
        return this.xmlCalendar;
    }

    public String toString() {
        return this.xmlCalendar.toXMLFormat();
    }

    @Override
    public int compareTo(Date date) {
        return this.xmlCalendar.compare(date.getCalendar());
    }

    public boolean equals(Object obj) {
        return obj instanceof Date && this.compareTo((Date)obj) == 0;
    }

    public int hashCode() {
        return this.xmlCalendar.hashCode();
    }

    public void add(YearMonthDuration duration) {
        this.xmlCalendar.add(duration.getDuration());
    }

    public void subtract(YearMonthDuration duration) {
        if (duration.getDuration().toString().charAt(0) == '-') {
            this.xmlCalendar.add(new YearMonthDuration(duration.getDuration().toString().substring(1)).getDuration());
        } else {
            this.xmlCalendar.add(new YearMonthDuration("-" + duration.getDuration().toString()).getDuration());
        }
    }
}

