/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.specialMatchFunctions;

import javax.security.auth.x500.X500Principal;
import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class X500NameMatchFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:x500Name-match";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length != 2) {
                throw new FunctionProcessingException("Invalid number of parameters");
            }
            String[] expectedName = ((X500Principal)args[0]).getName("RFC2253").split(",");
            String[] comparedName = ((X500Principal)args[1]).getName("RFC2253").split(",");
            for (int i = 0; i < expectedName.length; ++i) {
                boolean found = false;
                for (int k = 0; k < comparedName.length; ++k) {
                    if (!expectedName[i].trim().equals(comparedName[k].trim())) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (FunctionProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

