/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import java.math.BigInteger;
import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class IntegerAddFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:integer-add";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length < 2) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            BigInteger[] integers = new BigInteger[args.length];
            for (int i = 0; i < args.length; ++i) {
                integers[i] = (BigInteger)args[i];
            }
            BigInteger result = new BigInteger("0");
            for (BigInteger i : integers) {
                result = result.add(i);
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

