/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class DoubleDivideFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:double-divide";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length != 2) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            if ((Double)args[1] == 0.0) {
                throw new FunctionProcessingException("Dividing by 0 is not allowed");
            }
            return (Double)args[0] / (Double)args[1];
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

