/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.transformable.ActionTransformable;
import org.herasaf.xacml.core.context.transformable.EnvironmentTransformable;
import org.herasaf.xacml.core.context.transformable.ResourceTransformable;
import org.herasaf.xacml.core.context.transformable.SubjectTransformable;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class RequestCtxFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestCtxFactory.class);
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    public static void setJAXBContext(JAXBContext policyContext) {
        CONTEXT = policyContext;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration jmc) {
        CONFIGURATION = jmc;
    }

    private RequestCtxFactory() {
    }

    public static RequestCtx create(SubjectTransformable subjectTransformable, ResourceTransformable resourceTransformable, ActionTransformable actionTransformable, EnvironmentTransformable environmentTransformable) {
        RequestType req = OBJECT_FACTORY.createRequestType();
        req.getSubjects().addAll(subjectTransformable.transform());
        req.getResources().addAll(resourceTransformable.transform());
        req.setAction(actionTransformable.transform());
        req.setEnvironment(environmentTransformable.transform());
        return new RequestCtx(req);
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, PropertyException {
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        if (CONFIGURATION.isValidateParsing()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            unmarshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            unmarshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return unmarshaller;
    }

    public static RequestCtx unmarshal(File file) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(InputStream inputStream) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(Reader reader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(reader)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(URL url) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(url)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(InputSource inputSource) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(inputSource)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(Node node) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(node)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(Source source) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(source)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(XMLStreamReader xmlStreamReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(xmlStreamReader)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static RequestCtx unmarshal(XMLEventReader xmlEventReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = RequestCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            RequestType rt = (RequestType)((JAXBElement)unmarshaller.unmarshal(xmlEventReader)).getValue();
            return new RequestCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }
}

