/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.utils.deployment;

import de.fzj.unicore.wsrflite.impl.DefaultHome;
import de.fzj.unicore.wsrflite.utils.deployment.DeploymentDescriptor;
import de.fzj.unicore.wsrflite.utils.deployment.DeploymentDescriptorImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class DeploymentUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException, FileNotFoundException {
        if (!dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
            throw new IOException("Can't create parent directory");
        }
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inChannel = new FileInputStream(src).getChannel();
            outChannel = new FileOutputStream(dst).getChannel();
            inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
        inChannel = null;
        outChannel = null;
        System.gc();
    }

    public static String extractServiceNameFromJarFile(File jarFile) {
        String[] serviceNameParts = jarFile.getName().split("\\.");
        String serviceName = "";
        for (int a = 0; a < serviceNameParts.length - 1; ++a) {
            serviceName = serviceName.concat(serviceNameParts[a]);
            if (a >= serviceNameParts.length - 2) continue;
            serviceName = serviceName.concat(".");
        }
        return serviceName;
    }

    public static File[] listFilesByExtension(String pathToDir, final String extension) {
        File dir = new File(pathToDir);
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.toLowerCase().endsWith("." + extension);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeChecksum(File jarFile) throws IOException {
        long checksum = 0L;
        int l = (int)jarFile.length();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jarFile);
            CheckedInputStream cis = new CheckedInputStream(fis, new CRC32());
            byte[] tempBuf = new byte[l];
            cis.read(tempBuf);
            checksum = cis.getChecksum().getValue();
            cis.close();
            String string = Long.toString(checksum);
            return string;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static DeploymentDescriptorImpl extractDeploymentMetadata(File jarFile) throws IOException {
        DeploymentDescriptorImpl info = null;
        JarFile jf = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = name.replace('/', '.');
            name = name.substring(0, name.length() - 6);
            URL url = jarFile.toURI().toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{url});
            try {
                Class<?> theClass = Class.forName(name, true, cl);
                DeploymentDescriptor dd = theClass.getAnnotation(DeploymentDescriptor.class);
                if (dd != null) {
                    info = new DeploymentDescriptorImpl(dd);
                }
                if (info == null) continue;
                jf.close();
                theClass = null;
                cl = null;
                url = null;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (info == null) {
            String iFace = jf.getManifest().getMainAttributes().getValue("iFace");
            String impl = jf.getManifest().getMainAttributes().getValue("impl");
            String b2 = jf.getManifest().getMainAttributes().getValue("isPersistent");
            String initTask = jf.getManifest().getMainAttributes().getValue("initTask");
            String serviceType = jf.getManifest().getMainAttributes().getValue("serviceType");
            info = new DeploymentDescriptorImpl(serviceType, iFace, impl, Boolean.parseBoolean(b2), initTask);
            jf.close();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createJar(String pathToJarFile, byte[] jarAsBytes) throws IOException {
        File jarFile = new File(pathToJarFile);
        if (jarFile.exists()) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(jarAsBytes);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(jarFile);
            fos.write(jarAsBytes);
            fos.close();
            bis.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return jarFile;
    }

    public static boolean isWSRF(Class<?> classImpl) {
        String nameImplSuperClass = null;
        String nameDefaultHome = DefaultHome.class.getName();
        while (!nameDefaultHome.equals(nameImplSuperClass)) {
            if ((classImpl = classImpl.getSuperclass()) == null) {
                return false;
            }
            nameImplSuperClass = classImpl.getName();
        }
        return true;
    }

    public static File createDirectory(String path) throws IOException {
        File dir = new File(path);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return dir;
            }
            throw new IOException("Not a directory: " + path);
        }
        if (!dir.mkdirs() && dir.exists()) {
            if (dir.isDirectory()) {
                return dir;
            }
            throw new IOException("Not a directory: " + path);
        }
        return dir;
    }
}

