/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.server;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.ServiceFactory;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.HttpServerProperties;
import eu.unicore.util.jetty.JettyServerBase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyServer
extends JettyServerBase {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", JettyServer.class);
    private final Kernel kernel;
    private final WebAppContext presetWebappCtx;
    protected static final HashMap<String, Integer> defaults = new HashMap();

    public JettyServer(Kernel kernel, HttpServerProperties jettyCfg) throws Exception {
        this(kernel, null, jettyCfg);
    }

    public JettyServer(Kernel kernel, WebAppContext webappCtx, HttpServerProperties jettyCfg) throws Exception {
        super(JettyServer.makeUrl(kernel), (IAuthnAndTrustConfiguration)kernel.getContainerSecurityConfiguration(), jettyCfg);
        this.presetWebappCtx = webappCtx;
        this.kernel = kernel;
        this.initServer();
    }

    private static URL makeUrl(Kernel kernel) throws MalformedURLException {
        int port = 0;
        String host = kernel.getContainerProperties().getValue("host");
        String pString = kernel.getContainerProperties().getValue("port");
        if (pString != null) {
            port = Integer.parseInt(pString);
        }
        if (kernel.getContainerSecurityConfiguration().isSslEnabled()) {
            return new URL("https://" + host + ":" + port);
        }
        return new URL("http://" + host + ":" + port);
    }

    public void start() throws Exception {
        String baseUrlS;
        URL baseUrl;
        super.start();
        URL url = this.getUrls()[0];
        if ("0".equals(this.kernel.getContainerProperties().getValue("port"))) {
            this.kernel.getContainerProperties().setProperty("port", String.valueOf(url.getPort()));
        }
        if ((baseUrl = new URL(baseUrlS = this.kernel.getContainerProperties().getValue("baseurl"))).getPort() == 0 && baseUrl.getHost().equals(url.getHost())) {
            baseUrl = new URL(baseUrl.getProtocol(), baseUrl.getHost(), url.getPort(), baseUrl.getFile());
            this.kernel.getContainerProperties().setProperty("baseurl", baseUrl.toExternalForm());
        }
    }

    private Handler configureWithExistingWebAppCtx() {
        DefaultHandler defaultHandler = new DefaultHandler();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.presetWebappCtx, defaultHandler});
        this.presetWebappCtx.addDecorator((ServletContextHandler.Decorator)new ServletDecorator(this.kernel));
        return handlers;
    }

    protected void addServlets(ServletContextHandler root) throws ClassNotFoundException {
        for (ServiceFactory f : this.kernel.getServiceFactories()) {
            Servlet servlet = f.getServlet();
            String servletClass = f.getServletClass();
            String path = f.getServletPath();
            if (servlet != null) {
                ServletHolder sh = new ServletHolder(servlet);
                root.addServlet(sh, path);
            } else {
                Class<?> loadedClazz = Class.forName(servletClass);
                if (!Servlet.class.isAssignableFrom(loadedClazz)) {
                    throw new ConfigurationException("Class " + servletClass + " must extend Servlet class");
                }
                ServletHolder sh = new ServletHolder(loadedClazz);
                root.addServlet(sh, path);
            }
            logger.info((Object)("Added " + servlet + " on " + path + " for service type '" + f.getType() + "'"));
        }
    }

    protected Handler createRootHandler() throws ConfigurationException {
        if (this.presetWebappCtx != null) {
            return this.configureWithExistingWebAppCtx();
        }
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.getServer(), "/", 1);
        root.addDecorator((ServletContextHandler.Decorator)new ServletDecorator(this.kernel));
        try {
            this.addServlets(root);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Can't add servlet, as its class can not be loaded: " + e.getMessage(), (Throwable)e);
        }
        return root;
    }

    public ServletContextHandler getRootServletContext() {
        if (this.presetWebappCtx != null) {
            return this.presetWebappCtx;
        }
        return (ServletContextHandler)super.getRootHandler();
    }

    public static class ServletDecorator
    implements ServletContextHandler.Decorator {
        private final Kernel k;

        public ServletDecorator(Kernel k) {
            this.k = k;
        }

        private void decorate(Object o) {
            if (o instanceof KernelInjectable) {
                ((KernelInjectable)o).setKernel(this.k);
            }
        }

        public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
            this.decorate(filter);
            return filter;
        }

        public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
            this.decorate(servlet);
            return servlet;
        }

        public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
            this.decorate(listener);
            return listener;
        }

        public void decorateFilterHolder(FilterHolder filter) throws ServletException {
        }

        public void decorateServletHolder(ServletHolder servlet) throws ServletException {
        }

        public void destroyServletInstance(Servlet s) {
        }

        public void destroyFilterInstance(Filter f) {
        }

        public void destroyListenerInstance(EventListener f) {
        }
    }
}

