/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security.util;

import de.fzj.unicore.wsrflite.security.IDynamicAttributeSource;
import de.fzj.unicore.wsrflite.security.util.AttributeSourceConfigurator;
import de.fzj.unicore.wsrflite.security.util.BaseAttributeSourcesChain;
import eu.unicore.security.AuthorisationException;
import eu.unicore.security.Client;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class DynamicAttributeSourcesChain
extends BaseAttributeSourcesChain<IDynamicAttributeSource>
implements IDynamicAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", DynamicAttributeSourcesChain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubjectAttributesHolder getAttributes(Client client, SubjectAttributesHolder initial) throws IOException, AuthorisationException {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        SubjectAttributesHolder resultMap = new SubjectAttributesHolder(initial.getPreferredVos());
        for (IDynamicAttributeSource a : this.chain) {
            NDC.push((String)a.getName());
            try {
                SubjectAttributesHolder current = a.getAttributes(client, resultMap);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dynamic attribute source " + a.getName() + " returned the following attributes:\n" + current));
                }
                if (this.combiner.combineAttributes(resultMap, current)) continue;
                logger.debug((Object)("Dynamic attributes combiner decided to stop processing of attribute sources at " + a.getName() + "."));
                break;
            }
            catch (IOException e) {
                Log.logException((String)("Dynamic attribute source <" + a.getClass() + "> not available."), (Throwable)e, (Logger)logger);
            }
            finally {
                NDC.pop();
            }
        }
        return resultMap;
    }

    @Override
    protected void initOrder() throws ConfigurationException {
        this.chain = new ArrayList();
        this.names = new ArrayList();
        if (this.orderString == null) {
            String nn = this.name == null ? "" : "." + this.name;
            throw new ConfigurationException("Configuration inconsistent, need to define <dynamicAttributes" + nn + ".order>");
        }
        String[] authzNames = this.orderString.split(" +");
        if (this.properties == null) {
            throw new IllegalStateException("Properties are null. Please set them using setProperties()");
        }
        for (String auth : authzNames) {
            this.chain.add(AttributeSourceConfigurator.configureDynamicAttributeSource(auth, "dynamicAttributes", this.properties));
            this.names.add(auth);
        }
    }
}

