/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security.util;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IAttributeSourceBase;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.util.configuration.ConfigurationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.NDC;

public abstract class BaseAttributeSourcesChain<T extends IAttributeSourceBase>
implements IAttributeSourceBase {
    protected List<T> chain;
    protected List<String> names;
    protected String name;
    protected String orderString;
    protected String combinerName;
    protected CombiningPolicy combiner;
    protected Properties properties = null;
    protected boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(String name) throws ConfigurationException {
        this.name = name;
        this.initOrder();
        for (int i = 0; i < this.chain.size(); ++i) {
            NDC.push((String)this.names.get(i));
            try {
                ((IAttributeSourceBase)this.chain.get(i)).configure(this.names.get(i));
                continue;
            }
            finally {
                NDC.pop();
            }
        }
        this.initCombiningPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Kernel kernel) throws Exception {
        for (int i = 0; i < this.chain.size(); ++i) {
            NDC.push((String)this.names.get(i));
            try {
                ((IAttributeSourceBase)this.chain.get(i)).start(kernel);
                continue;
            }
            finally {
                NDC.pop();
            }
        }
        this.started = true;
    }

    @Override
    public String getStatusDescription() {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        for (IAttributeSourceBase a : this.chain) {
            sb.append(a.getStatusDescription());
            sb.append(lineSep);
        }
        if (this.chain.size() > 1) {
            sb.append("Combining policy: ").append(String.valueOf(this.combiner));
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public List<T> getChain() {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        return Collections.unmodifiableList(this.chain);
    }

    public CombiningPolicy getCombiningPolicy() {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        return this.combiner;
    }

    void merge(Map<String, String[]> master, Map<String, String[]> slave) {
        for (Map.Entry<String, String[]> e : slave.entrySet()) {
            master.put(e.getKey(), e.getValue());
        }
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public void setOrder(String order) {
        this.orderString = order;
    }

    public void setCombiningPolicy(String name) {
        this.combinerName = name;
    }

    protected abstract void initOrder() throws ConfigurationException;

    private void initCombiningPolicy() throws ConfigurationException {
        if ("MERGE_LAST_OVERRIDES".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new MergeLastOverrides();
        } else if ("MERGE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new Merge();
        } else if ("FIRST_APPLICABLE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new FirstApplicable();
        } else if ("FIRST_ACCESSIBLE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new FirstAccessible();
        } else {
            try {
                Object c = Class.forName(this.combinerName).newInstance();
                this.combiner = (CombiningPolicy)c;
            }
            catch (Exception ex) {
                throw new ConfigurationException("Can't create combining policy <" + this.combinerName + ">");
            }
        }
    }

    @Override
    public String getName() {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        return this.name == null ? "MainChain" : this.name;
    }

    public static class Merge
    implements CombiningPolicy {
        public static final String NAME = "MERGE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            master.addAllMerging(newAttributes);
            return true;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class MergeLastOverrides
    implements CombiningPolicy {
        public static final String NAME = "MERGE_LAST_OVERRIDES";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            master.addAllOverwritting(newAttributes);
            return true;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class FirstAccessible
    implements CombiningPolicy {
        public static final String NAME = "FIRST_ACCESSIBLE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            if (master.isPresent()) {
                return false;
            }
            master.addAllOverwritting(newAttributes);
            return false;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class FirstApplicable
    implements CombiningPolicy {
        public static final String NAME = "FIRST_APPLICABLE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            if (master.isPresent()) {
                return false;
            }
            if (!newAttributes.isPresent()) {
                return true;
            }
            master.addAllOverwritting(newAttributes);
            return false;
        }

        public String toString() {
            return NAME;
        }
    }

    public static interface CombiningPolicy {
        public boolean combineAttributes(SubjectAttributesHolder var1, SubjectAttributesHolder var2);
    }
}

