/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security.util;

import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AttributeSourceConfigurator;
import de.fzj.unicore.wsrflite.security.util.BaseAttributeSourcesChain;
import eu.unicore.security.AuthorisationException;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class AttributeSourcesChain
extends BaseAttributeSourcesChain<IAttributeSource>
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", AttributeSourcesChain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder initial) throws IOException, AuthorisationException {
        if (!this.started) {
            throw new IllegalStateException("This object must be started prior to be used.");
        }
        SubjectAttributesHolder resultMap = new SubjectAttributesHolder(initial.getPreferredVos());
        for (IAttributeSource a : this.chain) {
            NDC.push((String)a.getName());
            try {
                SubjectAttributesHolder current = a.getAttributes(tokens, resultMap);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attribute source " + a.getName() + " returned the following attributes:\n" + current));
                }
                if (this.combiner.combineAttributes(resultMap, current)) continue;
                logger.debug((Object)("Attributes combiner decided to stop processing of attribute sources at " + a.getName() + "."));
                break;
            }
            catch (Exception e) {
                Log.logException((String)("Attribute source <" + a.getClass() + "> not available."), (Throwable)e, (Logger)logger);
            }
            finally {
                NDC.pop();
            }
        }
        return resultMap;
    }

    @Override
    protected void initOrder() throws ConfigurationException {
        this.chain = new ArrayList();
        this.names = new ArrayList();
        if (this.orderString == null) {
            String nn = this.name == null ? "" : "." + this.name;
            throw new ConfigurationException("Configuration inconsistent, need to define <attributes" + nn + ".order>");
        }
        String[] authzNames = this.orderString.split(" +");
        if (this.properties == null) {
            throw new IllegalStateException("Properties are null. Please set them using setProperties()");
        }
        for (String auth : authzNames) {
            this.chain.add(AttributeSourceConfigurator.configureAttributeSource(auth, "attributes", this.properties));
            this.names.add(auth);
        }
    }

    @Override
    public VODescription[] getAcceptedVOs() {
        HashSet<VODescription> accepted = new HashSet<VODescription>();
        for (IAttributeSource as : this.chain) {
            VODescription[] asVos = as.getAcceptedVOs();
            if (asVos == null) continue;
            for (VODescription vo : asVos) {
                accepted.add(vo);
            }
        }
        return accepted.toArray(new VODescription[accepted.size()]);
    }

    public void checkVOConsistency() throws ConfigurationException {
        HashMap<String, String> supportedVOUris = new HashMap<String, String>();
        for (IAttributeSource as : this.chain) {
            VODescription[] asVos = as.getAcceptedVOs();
            if (asVos == null) continue;
            for (VODescription voDesc : asVos) {
                if (supportedVOUris.containsKey(voDesc.getVoName()) && !((String)supportedVOUris.get(voDesc.getVoName())).equals(voDesc.getVoServiceURI())) {
                    throw new ConfigurationException("There are two conflicting VOs configured with name " + voDesc.getVoName() + " from DIFFERENT VO services " + voDesc.getVoServiceURI() + " and " + (String)supportedVOUris.get(voDesc.getVoName()));
                }
                supportedVOUris.put(voDesc.getVoName(), voDesc.getVoServiceURI());
            }
        }
    }
}

