/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import de.fzj.unicore.wsrflite.utils.Utilities;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.UserAttributeHandler;
import eu.unicore.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class UserAttributeCallback
implements UserAttributeHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.security", UserAttributeCallback.class);
    public static final String USER_PREFERENCES_KEY = UserAttributeCallback.class.getCanonicalName();

    public void processUserDefinedAttribute(String name, String nameFormat, XmlObject[] values, SecurityTokens mainToken) {
        HashMap<String, String[]> preferences;
        if (!nameFormat.equals("urn:unicore:subject-requested-attribute")) {
            logger.debug((Object)("Ignoring request for unknown attribute of type <" + nameFormat + ">"));
        }
        if ((preferences = (HashMap<String, String[]>)mainToken.getContext().get(USER_PREFERENCES_KEY)) == null) {
            preferences = new HashMap<String, String[]>();
            mainToken.getContext().put(USER_PREFERENCES_KEY, preferences);
        }
        if (this.genericAttributeHandle("xlogin", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("group", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("role", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("supplementaryGroups", preferences, name, values, true)) {
            return;
        }
        if (this.genericAttributeHandle("addDefaultGroups", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("selectedVirtualOrganisation", preferences, name, values, false)) {
            return;
        }
        logger.debug((Object)("Ignoring request for unknown attribute named <" + name + ">"));
    }

    private boolean genericAttributeHandle(String processedName, Map<String, String[]> preferences, String name, XmlObject[] xmlValues, boolean multivalued) {
        Object[] values;
        if (!processedName.equals(name)) {
            return false;
        }
        if (!multivalued) {
            values = new String[]{Utilities.extractElementTextAsString(xmlValues[0])};
        } else {
            values = new String[xmlValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Utilities.extractElementTextAsString(xmlValues[i]);
            }
        }
        preferences.put(processedName, (String[])values);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got request for '" + processedName + "' with value <" + Arrays.toString(values) + ">"));
        }
        return true;
    }
}

