/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import de.fzj.unicore.wsrflite.security.DSignCheck;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.IDynamicAttributeSource;
import de.fzj.unicore.wsrflite.security.NullAttributeSource;
import de.fzj.unicore.wsrflite.security.OperationTypesUtil;
import de.fzj.unicore.wsrflite.security.UserAttributeCallback;
import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.pdp.PDPResult;
import de.fzj.unicore.wsrflite.security.util.AttributeHandlingCallback;
import de.fzj.unicore.wsrflite.security.util.BaseAttributeSourcesChain;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.AuthorisationException;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.security.Queue;
import eu.unicore.security.Role;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.Xlogin;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public final class SecurityManager {
    private static final Logger logger = Log.getLogger((String)"unicore.security", SecurityManager.class);
    public static final String UNKNOWN_ACTION = "___ANY_ACTION___";
    private final IContainerSecurityConfiguration securityConfig;
    private static final ThreadLocal<Boolean> localCalls = new ThreadLocal();
    private Set<AttributeHandlingCallback> attribHandlingCallbacks = new HashSet<AttributeHandlingCallback>();
    private DSignCheck signatureChecker;
    private OperationTypesUtil operationTypesUtil;

    public SecurityManager(IContainerSecurityConfiguration securityConfig) {
        this.securityConfig = securityConfig;
        this.signatureChecker = new DSignCheck(securityConfig.isSigningRequired());
        this.operationTypesUtil = new OperationTypesUtil();
    }

    public void addCallback(AttributeHandlingCallback aac) {
        this.attribHandlingCallbacks.add(aac);
    }

    public SubjectAttributesHolder establishAttributes(SecurityTokens tokens) throws Exception {
        Map preferences = (Map)tokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY);
        String[] preferedVos = null;
        preferedVos = preferences != null && preferences.get("selectedVirtualOrganisation") != null ? new String[]{((String[])preferences.get("selectedVirtualOrganisation"))[0]} : this.securityConfig.getDefaultVOs();
        SubjectAttributesHolder initial = new SubjectAttributesHolder(preferedVos);
        return this.securityConfig.getAip().getAttributes(tokens, initial);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleXlogin(Client client, Map<String, String[]> preferences, Map<String, String[]> validAttributes, Map<String, String[]> defaultAttributes) {
        String[] reqAddDefaultGroups;
        String[] reqSupGroups;
        String[] reqGroup;
        String[] reqXlogin;
        String[] defaultSupGroups;
        String[] validSupGroups;
        String[] defaultPGroup;
        String[] validXlogins = validAttributes.get("xlogin");
        String[] defaultXlogin = defaultAttributes.get("xlogin");
        String[] validPGroups = validAttributes.get("group");
        if (validPGroups == null) {
            validPGroups = new String[]{};
        }
        if ((defaultPGroup = defaultAttributes.get("group")) == null) {
            defaultPGroup = new String[]{};
        }
        if ((validSupGroups = validAttributes.get("supplementaryGroups")) == null) {
            validSupGroups = new String[]{};
        }
        if ((defaultSupGroups = defaultAttributes.get("supplementaryGroups")) == null) {
            defaultSupGroups = new String[]{};
        }
        HashSet validGroups = new HashSet();
        Collections.addAll(validGroups, validPGroups);
        Collections.addAll(validGroups, validSupGroups);
        String[] pAddDefaultGids = defaultAttributes.get("addDefaultGroups");
        if (pAddDefaultGids == null || pAddDefaultGids.length == 0) {
            pAddDefaultGids = validAttributes.get("addDefaultGroups");
        }
        if (validXlogins == null || validXlogins.length <= 0) return;
        Xlogin xlogin = new Xlogin(validXlogins, validGroups.toArray(new String[validGroups.size()]));
        if (defaultXlogin != null && defaultXlogin.length > 0) {
            xlogin.setSelectedLogin(defaultXlogin[0]);
        }
        if (defaultPGroup.length > 0) {
            xlogin.setSelectedGroup(defaultPGroup[0]);
        }
        if (defaultSupGroups.length > 0) {
            xlogin.setSelectedSupplementaryGroups(defaultSupGroups);
        }
        if ((reqXlogin = preferences.get("xlogin")) != null && reqXlogin.length > 0) {
            xlogin.setSelectedLogin(reqXlogin[0]);
        }
        if ((reqGroup = preferences.get("group")) != null && reqGroup.length > 0) {
            xlogin.setSelectedGroup(reqGroup[0]);
        }
        if ((reqSupGroups = preferences.get("supplementaryGroups")) != null && reqSupGroups.length > 0) {
            xlogin.setSelectedSupplementaryGroups(reqSupGroups);
        }
        if ((reqAddDefaultGroups = preferences.get("addDefaultGroups")) != null && reqAddDefaultGroups.length > 0) {
            if (reqAddDefaultGroups[0].equalsIgnoreCase("true")) {
                xlogin.setAddDefaultGroups(true);
            } else {
                if (!reqAddDefaultGroups[0].equalsIgnoreCase("false")) throw new SecurityException("Requested value <" + reqAddDefaultGroups[0] + "> is invalid for " + "addDefaultGroups" + " attribute; use 'true' or 'false'.");
                xlogin.setAddDefaultGroups(false);
            }
        } else if (pAddDefaultGids != null && pAddDefaultGids.length > 0) {
            if (pAddDefaultGids[0].equalsIgnoreCase("true")) {
                xlogin.setAddDefaultGroups(true);
            } else if (pAddDefaultGids[0].equalsIgnoreCase("false")) {
                xlogin.setAddDefaultGroups(false);
            }
        }
        client.setXlogin(xlogin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleRole(Client client, Map<String, String[]> preferences, Map<String, String[]> validAttributes, Map<String, String[]> defaultAttributes) {
        Role r;
        String[] validRoles = validAttributes.get("role");
        if (validRoles == null || validRoles.length == 0) {
            r = new Role("anonymous", "default role");
        } else {
            r = new Role(validRoles);
            String[] defaultRole = defaultAttributes.get("role");
            String[] prefRole = preferences.get("role");
            if (prefRole != null && prefRole.length > 0) {
                if (!r.isValid(prefRole[0])) throw new SecurityException("Requested role <" + prefRole[0] + "> is not available.");
                r.setName(prefRole[0]);
                r.setDescription("user's preferred role");
            } else if (defaultRole != null && defaultRole.length > 0) {
                r.setName(defaultRole[0]);
                r.setDescription("role from attribute source");
            } else {
                r.setDescription("default role from attribute source");
            }
        }
        client.setRole(r);
    }

    private static void handleQueue(Client client, Map<String, String[]> preferences, Map<String, String[]> validAttributes, Map<String, String[]> defaultAttributes) {
        Queue q = new Queue();
        String[] validQueues = validAttributes.get("queue");
        String[] defQueue = defaultAttributes.get("queue");
        if (validQueues != null && validQueues.length > 0) {
            q.setValidQueues(validQueues);
            if (defQueue != null && defQueue.length > 0) {
                q.setSelectedQueue(defQueue[0]);
            }
        }
        client.setQueue(q);
    }

    private static void handleVo(String selectedVo, Client client, Map<String, String[]> validAttributes) {
        String[] vos = validAttributes.get("virtualOrganisations");
        if (vos != null) {
            client.setVos(vos);
        }
        if (selectedVo != null) {
            int i;
            if (vos == null) {
                logger.fatal((Object)"BUG! attribute handlers set a VO for the request, but the user is not member of any VO");
                throw new SecurityException("BUG! attribute handlers set a VO for the request, but the user is not member of any VO");
            }
            for (i = 0; i < vos.length && !vos[i].equals(selectedVo); ++i) {
            }
            if (i == vos.length) {
                logger.fatal((Object)"BUG! attribute handlers set a VO for the request, but the user is not a member of this VO");
                throw new SecurityException("BUG! attribute handlers set a VO for the request, but the user is not a member of this VO");
            }
            client.setVo(selectedVo);
        }
    }

    private void assembleClientAttributes(Client client, SecurityTokens tokens) {
        if (this.isServer(client)) {
            Role r = new Role("server", "Server self access pseudo-role");
            client.setRole(r);
        } else {
            SubjectAttributesHolder subAttributes;
            try {
                subAttributes = this.establishAttributes(tokens);
            }
            catch (Exception e) {
                throw new SecurityException("Exception when getting attributes for the client.", e);
            }
            client.setSubjectAttributes(subAttributes);
            Map<String, String[]> preferences = (Map<String, String[]>)tokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY);
            if (preferences == null) {
                preferences = Collections.emptyMap();
            }
            Map validAttributes = client.getSubjectAttributes().getValidIncarnationAttributes();
            Map defaultAttributes = client.getSubjectAttributes().getIncarnationAttributes();
            SecurityManager.handleRole(client, preferences, validAttributes, defaultAttributes);
            SecurityManager.handleVo(subAttributes.getSelectedVo(), client, validAttributes);
            for (AttributeHandlingCallback a : this.attribHandlingCallbacks) {
                Map<String, Serializable> attribs = a.extractAttributes(tokens);
                if (attribs == null) continue;
                client.getExtraAttributes().putAll(attribs);
            }
        }
    }

    private Client createSecureClient(SecurityTokens tokens) {
        Client client = new Client();
        client.setAuthenticatedClient(tokens);
        if (client.getType() == Client.Type.ANONYMOUS) {
            logger.warn((Object)"There is no authentication material to create a real client, returning anonymous client.");
            return client;
        }
        this.assembleClientAttributes(client, tokens);
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("Client info (after static AIPs):\n" + client.toString()));
            try {
                SecurityTokens st = client.getSecurityTokens();
                if (st != null) {
                    logger.debug((Object)("TD Chain length=" + st.getTrustDelegationTokens().size()));
                }
            }
            catch (Exception e) {
                logger.debug((Object)"No TD.");
            }
        }
        return client;
    }

    public Client createClientWithAttributes(SecurityTokens tokens) {
        Client client;
        if (SecurityManager.isLocalCall()) {
            client = new Client();
            client.setLocalClient();
        } else {
            client = this.securityConfig.isAccessControlEnabled() ? this.createSecureClient(tokens) : new Client();
        }
        if (SecurityManager.isTrustedAgent(client)) {
            if (logger.isDebugEnabled()) {
                String consignor = tokens.getConsignorCertificate().getSubjectX500Principal().getName();
                logger.debug((Object)("Accept trusted-agent " + X500NameUtils.getReadableForm((String)consignor) + " to work on selected user's behalf " + X500NameUtils.getReadableForm((X500Principal)tokens.getUserName())));
            }
            tokens.setConsignorTrusted(true);
        }
        MDC.put((String)"clientName", (Object)client.getDistinguishedName());
        return client;
    }

    public DSignCheck getSignatureChecker() {
        return this.signatureChecker;
    }

    private PDPResult.Decision checkAuthzInternal(Client c, ActionDescriptor action, ResourceDescriptor d) {
        PDPResult res;
        try {
            res = this.securityConfig.getPdp().checkAuthorisation(c, action, d);
        }
        catch (Exception e) {
            throw new AuthorisationException("Access denied due to PDP error: " + e, (Throwable)e);
        }
        if (res.getDecision().equals((Object)PDPResult.Decision.UNCLEAR)) {
            logger.warn((Object)"The UNICORE/X PDP was unable to make a definitive decision, check your policy files and consult other log messages.");
        }
        if (res.getDecision().equals((Object)PDPResult.Decision.DENY) && logger.isDebugEnabled()) {
            if (res.getMessage() != null && res.getMessage().length() > 0) {
                logger.debug((Object)("The UNICORE/X PDP denied the request: " + res.getMessage()));
            } else {
                logger.debug((Object)"The UNICORE/X PDP denied the request");
            }
        }
        return res.getDecision();
    }

    public void checkAuthorisation(Client c, ActionDescriptor action, ResourceDescriptor d) throws AuthorisationException {
        PDPResult.Decision decision = this.checkAuthzInternal(c, action, d);
        if (!decision.equals((Object)PDPResult.Decision.PERMIT)) {
            String msg = "Access denied for " + c.getDistinguishedName() + " on resource " + d;
            logger.info((Object)msg);
            throw new AuthorisationException(msg);
        }
    }

    public boolean isAccessible(Client client, String serviceName, String wsResourceID, String owner, Map<String, Set<OperationType>> voMembership) throws Exception {
        if (!this.securityConfig.isAccessControlEnabled()) {
            return true;
        }
        if (this.isServer(client)) {
            return true;
        }
        ResourceDescriptor resource = new ResourceDescriptor(serviceName, wsResourceID, owner, voMembership);
        PDPResult.Decision decision = this.checkAuthzInternal(client, new ActionDescriptor(UNKNOWN_ACTION, OperationType.read), resource);
        return decision.equals((Object)PDPResult.Decision.PERMIT);
    }

    public void collectDynamicAttributes(Client client) {
        Map<String, String[]> preferences;
        if (this.isServer(client)) {
            return;
        }
        SecurityTokens tokens = client.getSecurityTokens();
        SubjectAttributesHolder staticSubAttributes = client.getSubjectAttributes();
        IDynamicAttributeSource dap = this.securityConfig.getDap();
        if (!(dap instanceof NullAttributeSource)) {
            SubjectAttributesHolder dynamicSubAttributes;
            try {
                dynamicSubAttributes = dap.getAttributes(client, staticSubAttributes);
            }
            catch (Exception e) {
                throw new SecurityException("Exception when getting dynamic attributes for the client.", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Client's dynamic attributes:\n" + dynamicSubAttributes));
            }
            BaseAttributeSourcesChain.MergeLastOverrides combiner = new BaseAttributeSourcesChain.MergeLastOverrides();
            combiner.combineAttributes(staticSubAttributes, dynamicSubAttributes);
        }
        if ((preferences = (Map<String, String[]>)tokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY)) == null) {
            preferences = Collections.emptyMap();
        }
        Map validAttributes = client.getSubjectAttributes().getValidIncarnationAttributes();
        Map defaultAttributes = client.getSubjectAttributes().getIncarnationAttributes();
        SecurityManager.handleXlogin(client, preferences, validAttributes, defaultAttributes);
        SecurityManager.handleQueue(client, preferences, validAttributes, defaultAttributes);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Client info (final):\n" + client.toString()));
        }
    }

    public static void setLocalCall() {
        localCalls.set(Boolean.TRUE);
    }

    public static void clearLocalCall() {
        localCalls.set(null);
    }

    public static boolean isLocalCall() {
        return Boolean.TRUE.equals(localCalls.get());
    }

    public X509Certificate getServerCert() {
        if (this.securityConfig.getCredential() != null) {
            return this.securityConfig.getCredential().getCertificate();
        }
        return null;
    }

    public String getServerIdentity() {
        if (this.getServerCert() != null) {
            return this.getServerCert().getSubjectX500Principal().getName();
        }
        return null;
    }

    public boolean isServer(Client c) {
        if (c == null) {
            throw new IllegalArgumentException("client can not be null");
        }
        X509Certificate serverCert = this.getServerCert();
        if (serverCert == null) {
            return false;
        }
        String dn = serverCert.getSubjectX500Principal().getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Check server=<" + X500NameUtils.getReadableForm((X500Principal)serverCert.getSubjectX500Principal()) + "> " + " vs client=<" + X500NameUtils.getReadableForm((String)c.getDistinguishedName()) + ">"));
        }
        return X500NameUtils.equal((String)dn, (String)c.getDistinguishedName());
    }

    public boolean isServer(X509Certificate cert) {
        X509Certificate serverCert = this.getServerCert();
        return serverCert == null ? false : serverCert.equals(cert);
    }

    private static boolean isTrustedAgent(Client c) {
        try {
            return "trusted-agent".equals(c.getRole().getName());
        }
        catch (Exception e) {
            Log.logException((String)"Could not check whether client is trusted agent.", (Throwable)e, (Logger)logger);
            return false;
        }
    }

    public OperationTypesUtil getOperationTypesUtil() {
        return this.operationTypesUtil;
    }
}

