/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.security;

import de.fzj.unicore.metrix.AbstractMetric;
import de.fzj.unicore.metrix.MetricValue;
import de.fzj.unicore.wsrflite.security.SecurityManager;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;

public class CertificateInfoMetric
extends AbstractMetric<String> {
    private final SecurityManager secManager;
    public static final String NAME = "use.security.overview";

    public CertificateInfoMetric(SecurityManager secManager) {
        super(NAME, new String[]{"system"});
        this.secManager = secManager;
    }

    protected MetricValue doGetValue() {
        MetricValue mv = new MetricValue(this.getName(), (Object)this.getResult(), this.getMetricUnit(), System.currentTimeMillis());
        return mv;
    }

    protected void doPush(String ... data) {
    }

    public String getMetricUnit() {
        return "n/a";
    }

    public String getResult() {
        StringBuilder sb = new StringBuilder();
        try {
            X509Certificate cert = this.secManager.getServerCert();
            if (cert != null) {
                sb.append("ServerIdentity: " + this.secManager.getServerIdentity());
                sb.append(";");
                sb.append("Expires: " + cert.getNotAfter());
                sb.append(";");
                sb.append("IssuedBy: " + cert.getIssuerX500Principal().getName());
            } else {
                sb.append("<not available>");
            }
        }
        catch (Exception e) {
            sb.append("<not available: " + Log.createFaultMessage((String)"", (Throwable)e) + ">");
        }
        return sb.toString();
    }
}

