/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.wsrflite.persistence.LoadSemantics;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.persistence.Persistent;
import eu.unicore.util.ConcurrentAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersistenceSettings {
    protected static final Logger logger = Logger.getLogger(PersistenceSettings.class);
    private boolean loadOnce;
    private Map<String, Field> fieldMap;
    private List<String> concurrentMethods = new ArrayList<String>();

    public PersistenceSettings() {
    }

    public PersistenceSettings(boolean loadOnce, Map<String, Field> persistentFields) {
        this.loadOnce = loadOnce;
        this.fieldMap = persistentFields;
    }

    public Set<String> getPersistentFieldKeys() {
        return this.fieldMap.keySet();
    }

    public List<String> getConcurrentMethodNames() {
        return this.concurrentMethods;
    }

    public static PersistenceSettings get(Class<?> spec) {
        if (spec == null) {
            return null;
        }
        logger.debug((Object)("Generating persistence settings for class " + spec.getName()));
        PersistenceSettings persistenceSettings = new PersistenceSettings();
        boolean loadOnce = false;
        Persistent p = spec.getAnnotation(Persistent.class);
        if (p != null) {
            loadOnce = p.loadSemantics().equals((Object)LoadSemantics.LOAD_ONCE);
        }
        persistenceSettings.loadOnce = loadOnce;
        persistenceSettings.fieldMap = PersistenceSettings.findPersistentFields(spec);
        persistenceSettings.concurrentMethods = PersistenceSettings.findConcurrentMethods(spec);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Persistence settings for " + spec.getName() + "\n" + persistenceSettings.toString()));
        }
        return persistenceSettings;
    }

    public boolean isLoadOnce() {
        return this.loadOnce;
    }

    public boolean isConcurrentMethod(String methodName) {
        if (methodName == null) {
            return false;
        }
        return this.concurrentMethods.contains(methodName);
    }

    public boolean isConcurrentMethod(Method method) {
        if (method == null) {
            return false;
        }
        return this.concurrentMethods.contains(method.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" isLoadOnce=" + this.isLoadOnce());
        sb.append(" persistentFields=[");
        for (String f : this.fieldMap.keySet()) {
            sb.append(f + " ");
        }
        sb.append(" concurrent methods=" + this.concurrentMethods.toString());
        return sb.toString();
    }

    public static Map<String, Field> findPersistentFields(Class<?> spec) {
        Map<String, Field> persistentFields = new HashMap<String, Field>();
        try {
            Field[] fields;
            if (!spec.getSuperclass().equals(Object.class)) {
                persistentFields = PersistenceSettings.findPersistentFields(spec.getSuperclass());
            }
            for (Field f : fields = spec.getDeclaredFields()) {
                if (!PersistenceSettings.accept(f)) continue;
                f.setAccessible(true);
                String s = spec.getName() + "_" + f.getName();
                persistentFields.put(s, f);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Persisting field " + f.getName() + " for class " + spec.getName()));
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Could not create list of persistent fields. Persistence will not work!!", (Throwable)e);
        }
        return persistentFields;
    }

    public static List<String> findConcurrentMethods(Class<?> spec) {
        List<String> concurrentMethods = new ArrayList<String>();
        try {
            Method[] methods;
            if (!spec.getSuperclass().equals(Object.class)) {
                concurrentMethods = PersistenceSettings.findConcurrentMethods(spec.getSuperclass());
            }
            for (Method m : methods = spec.getDeclaredMethods()) {
                ConcurrentAccess access = m.getAnnotation(ConcurrentAccess.class);
                if (access == null) continue;
                boolean val = access.allow();
                if (val) {
                    concurrentMethods.add(m.getName());
                    continue;
                }
                concurrentMethods.remove(m.getName());
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Could not create list of concurrent methods", (Throwable)e);
        }
        return concurrentMethods;
    }

    private static boolean accept(Field f) {
        return f.isAnnotationPresent(Persist.class);
    }

    public Field getField(String key) {
        return this.fieldMap.get(key);
    }

    public static PersistenceSettings getDefaultSettings() {
        return new PersistenceSettings(false, new HashMap<String, Field>());
    }
}

