/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.persistence;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.metrics.MeanFloatValue;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.persistence.PersistenceSettings;
import de.fzj.unicore.wsrflite.persistence.ResourceBean;
import de.fzj.unicore.wsrflite.persistence.Store;
import eu.unicore.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class AbstractStore
implements Store {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite.persistence", AbstractStore.class);
    protected String serviceName;
    protected PersistenceSettings settings = PersistenceSettings.getDefaultSettings();
    protected ConcurrentMap<String, Resource> instances;
    private IMetric<Float> meanReadDuration;
    private IMetric<Float> meanWriteDuration;
    protected Kernel kernel;

    @Override
    public synchronized void init(Kernel kernel, String serviceName) {
        this.kernel = kernel;
        this.serviceName = serviceName;
        this.instances = new ConcurrentHashMap<String, Resource>();
        this.meanReadDuration = new MeanFloatValue("persistence.meanReadDuration." + serviceName, "", new String[]{"services." + serviceName});
        this.meanWriteDuration = new MeanFloatValue("persistence.meanWriteDuration." + serviceName, "", new String[]{"services." + serviceName});
    }

    @Override
    public void persist(Resource inst) throws PersistenceException {
        long start = System.currentTimeMillis();
        this.settings = this.kernel.getPersistenceManager().getPersistenceSettings(inst.getClass());
        if (this.settings.isLoadOnce()) {
            this.instances.put(inst.getUniqueID(), inst);
        }
        ResourceBean bean = new ResourceBean(inst.getUniqueID(), inst.getServiceName(), inst.getClass().getName(), inst.passivate());
        this._persist(bean);
        this.meanWriteDuration.push((Object[])new Float[]{Float.valueOf(System.currentTimeMillis() - start)});
    }

    @Override
    public void unlock(Resource inst) {
        try {
            ResourceBean bean = new ResourceBean(inst.getUniqueID(), inst.getServiceName(), inst.getClass().getName(), null);
            this._unlock(bean);
        }
        catch (Exception e) {
            String msg = inst != null ? inst.getServiceName() + "[" + inst.getUniqueID() + "]" : "[null]";
            Log.logException((String)("Error persisting " + msg), (Throwable)e, (Logger)logger);
        }
    }

    protected abstract void _unlock(ResourceBean var1) throws PersistenceException;

    protected abstract void _persist(ResourceBean var1) throws PersistenceException;

    @Override
    public Resource read(String uniqueID) throws PersistenceException {
        long start = System.currentTimeMillis();
        Resource inst = null;
        if (this.settings.isLoadOnce() && (inst = (Resource)this.instances.get(uniqueID)) != null) {
            inst.setKernel(this.kernel);
            return inst;
        }
        ResourceBean bean = null;
        try {
            bean = this._read(uniqueID);
            this.meanReadDuration.push((Object[])new Float[]{Float.valueOf(System.currentTimeMillis() - start)});
            if (bean != null) {
                ClassLoader cl = this.kernel.getService(bean.serviceName).getClassLoader();
                Class<?> clazz = Class.forName(bean.className, true, cl);
                inst = (Resource)clazz.newInstance();
                inst.setUniqueID(bean.uniqueID);
                inst.setServiceName(bean.serviceName);
                inst.setKernel(this.kernel);
                inst.setHome(this.kernel.getHome(this.serviceName));
                inst.activate(bean.getState());
                if (this.settings.isLoadOnce()) {
                    this.instances.put(uniqueID, inst);
                }
                bean = null;
            }
        }
        catch (Exception e) {
            Log.logException((String)("Error reading instance of service '" + this.serviceName + "'."), (Throwable)e, (Logger)logger);
        }
        return inst;
    }

    protected abstract ResourceBean _read(String var1) throws PersistenceException;

    @Override
    public Resource getForUpdate(String uniqueID, long time, TimeUnit timeUnit) throws TimeoutException {
        long start = System.currentTimeMillis();
        Resource inst = null;
        if (this.settings.isLoadOnce() && (inst = (Resource)this.instances.get(uniqueID)) != null) {
            return inst;
        }
        ResourceBean bean = null;
        try {
            bean = this._getForUpdate(uniqueID, time, timeUnit);
            this.meanReadDuration.push((Object[])new Float[]{Float.valueOf(System.currentTimeMillis() - start)});
            if (bean != null) {
                ClassLoader cl = this.kernel.getService(bean.serviceName).getClassLoader();
                inst = (Resource)Class.forName(bean.className, true, cl).newInstance();
                inst.setUniqueID(bean.uniqueID);
                inst.setServiceName(bean.serviceName);
                inst.setKernel(this.kernel);
                inst.setHome(this.kernel.getHome(this.serviceName));
                inst.activate(bean.getState());
                if (this.settings.isLoadOnce()) {
                    this.instances.put(uniqueID, inst);
                }
                if (bean.deserialisationErrorsOccured) {
                    // empty if block
                }
                bean = null;
            }
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (Exception e) {
            Log.logException((String)("Error reading instance of service '" + this.serviceName + "'."), (Throwable)e, (Logger)logger);
        }
        return inst;
    }

    protected abstract ResourceBean _getForUpdate(String var1, long var2, TimeUnit var4) throws Exception;

    @Override
    public void remove(String uniqueID) throws PersistenceException {
        this._remove(uniqueID);
        if (this.settings.isLoadOnce()) {
            this.instances.remove(uniqueID);
        }
    }

    protected abstract void _remove(String var1) throws PersistenceException;

    @Override
    public int size() throws PersistenceException {
        return this.getUniqueIDs().size();
    }

    public long getCacheHits() {
        return -1L;
    }

    public void setPersistenceSettings(PersistenceSettings ps) {
        this.settings = ps;
    }

    public PersistenceSettings getPersistenceSettings() {
        return this.settings;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, String> getStatistics() {
        return null;
    }
}

