/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.wsrflite.ExtendedResourceStatus;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Node;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.impl.DefaultHome;
import de.fzj.unicore.wsrflite.impl.NodeHelper;
import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.persistence.PersistenceSettings;
import de.fzj.unicore.wsrflite.utils.Utilities;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public abstract class ResourceImpl
extends SecuredResourceImpl
implements ExtendedResourceStatus {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", ResourceImpl.class);
    private String uniqueID;
    private String serviceName;
    protected Home home;
    protected Kernel kernel;
    protected boolean isDirty = false;
    private boolean isDestroyed = false;
    @Persist
    private Calendar terminationTime;
    @Persist
    protected long lastRefreshNotificationInstant;
    @Persist
    private String resourceStatusDetails;
    @Persist
    private ExtendedResourceStatus.ResourceStatus resourceStatus = ExtendedResourceStatus.ResourceStatus.UNDEFINED;
    @Persist
    protected NodeHelper nodeHelper;
    public static final String INIT_UNIQUE_ID = ResourceImpl.class.getName() + ".init.uniqueid";
    public static final String INIT_INITIAL_TERMINATION_TIME = "de.fzj.unicore.wsrflite.terminationtime.initialvalue";
    public static final String INITPARAM_PUBLISH_TO_REGISTRY = ResourceImpl.class.getName() + ".init.publish";
    public static final String INIT_PARENT_NODE = ResourceImpl.class.getName() + ".init.parent_node";

    public ResourceImpl() {
        this.uniqueID = Utilities.newUniqueID();
    }

    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearChangeFlag() {
        this.isDirty = false;
    }

    @Override
    public String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public boolean isExpired() {
        if (this.terminationTime == null) {
            return false;
        }
        return this.terminationTime.compareTo(Calendar.getInstance()) <= 0;
    }

    @Override
    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public void setTerminationTime(Calendar newTT) throws UnableToSetTerminationTimeException {
        Integer maxLifetime = this.getKernel().getContainerProperties().getSubkeyIntValue("wsrf.lifetime.maximum", this.serviceName);
        try {
            if (maxLifetime != null) {
                boolean exceeded = false;
                if (newTT == null) {
                    exceeded = true;
                } else {
                    long req = (newTT.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
                    if (req > (long)maxLifetime.intValue()) {
                        exceeded = true;
                    }
                }
                if (exceeded) {
                    throw new IllegalArgumentException("Requested lifetime is larger than maximum configured on the system.");
                }
            }
            this.terminationTime = newTT;
            if (this.home != null) {
                this.home.setTerminationTime(this.uniqueID, newTT);
            }
        }
        catch (Exception e) {
            Log.logException((String)"Error setting tt.", (Throwable)e, (Logger)logger);
            throw new UnableToSetTerminationTimeException(e);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.isDirty;
    }

    @Override
    public void destroy() {
        try {
            X500Principal owner = this.getOwner();
            ((DefaultHome)this.home).instanceDestroyed(owner.toString());
        }
        catch (Exception ex) {
            Log.logException((String)"Error decreasing number of service instances.", (Throwable)ex, (Logger)logger);
        }
        this.isDestroyed = true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public void setHome(Home home) {
        this.home = home;
    }

    @Override
    public Home getHome() {
        return this.home;
    }

    @Override
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        Calendar tt;
        String uniqueID;
        this.serviceName = serviceName;
        if (initParams == null) {
            initParams = new HashMap<String, Object>();
        }
        if ((uniqueID = (String)initParams.get(INIT_UNIQUE_ID)) != null) {
            this.setUniqueID(uniqueID);
        }
        if ((tt = (Calendar)initParams.get(INIT_INITIAL_TERMINATION_TIME)) == null) {
            tt = new GregorianCalendar();
            tt.add(13, this.getDefaultLifetime());
        }
        this.setTerminationTime(tt);
        super.initialise(serviceName, initParams);
        Node parent = (Node)initParams.get(INIT_PARENT_NODE);
        this.nodeHelper = new NodeHelper(this.getUniqueID(), this.getServiceName(), parent);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialised <" + this.getServiceName() + ">" + this.getUniqueID() + ", TT = " + tt.getTime()));
        }
    }

    protected int getDefaultLifetime() {
        return this.getKernel().getContainerProperties().getSubkeyIntValue("wsrf.lifetime.default", this.serviceName);
    }

    @Override
    public Map<String, Serializable> passivate() {
        Map<String, Serializable> map = super.passivate();
        PersistenceSettings ps = this.getKernel().getPersistenceManager().getPersistenceSettings(this.getClass());
        Set<String> keys = ps.getPersistentFieldKeys();
        for (String key : keys) {
            Field f = ps.getField(key);
            try {
                Serializable o = (Serializable)f.get(this);
                if (o == null) continue;
                map.put(key, o);
            }
            catch (Exception e) {
                Log.logException((String)("INTERNAL ERROR persisting: " + f.getName() + " for service " + this.getServiceName()), (Throwable)e, (Logger)logger);
            }
        }
        return map;
    }

    @Override
    public void activate(Map<String, Serializable> state) {
        PersistenceSettings ps = this.getKernel().getPersistenceManager().getPersistenceSettings(this.getClass());
        Set<String> keys = ps.getPersistentFieldKeys();
        for (String key : keys) {
            Field f = ps.getField(key);
            try {
                Serializable val = state.get(key);
                if (val == null && (SecuredResourceImpl.class.getName() + "_owner").equals(key)) {
                    val = state.get(ResourceImpl.class.getName() + "_owner");
                }
                if (val == null) continue;
                f.set(this, val);
            }
            catch (IllegalAccessException e) {
                Log.logException((String)("INTERNAL ERROR writing: " + f.getName()), (Throwable)e, (Logger)logger);
            }
        }
        this.isDirty = false;
    }

    @Override
    public void postActivate() {
        this.recreateTreeStructure();
    }

    @Override
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    @Override
    public void processMessages(PullPoint messageIterator) {
    }

    @Override
    public void processConfigurationChange() {
    }

    @Override
    public void postRestart() throws Exception {
    }

    public long getLastRefreshNotificationInstant() {
        return this.lastRefreshNotificationInstant;
    }

    public void setLastRefreshNotificationInstant(long lastRefreshNotificationInstant) {
        this.lastRefreshNotificationInstant = lastRefreshNotificationInstant;
    }

    @Override
    public boolean isReady() {
        return ExtendedResourceStatus.ResourceStatus.READY == this.resourceStatus;
    }

    @Override
    public ExtendedResourceStatus.ResourceStatus getResourceStatus() {
        return this.resourceStatus;
    }

    @Override
    public void setResourceStatus(ExtendedResourceStatus.ResourceStatus resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    @Override
    public String getStatusMessage() {
        return this.resourceStatusDetails;
    }

    @Override
    public void setStatusMessage(String message) {
        this.resourceStatusDetails = message;
    }

    protected synchronized void recreateTreeStructure() {
        if (this.nodeHelper == null) {
            this.nodeHelper = new NodeHelper(this.getUniqueID(), this.getServiceName(), null);
        }
    }

    @Override
    public Node getNode() {
        return this.nodeHelper;
    }
}

