/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.impl.InstanceChecker;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class InstanceChecking
implements Runnable {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", InstanceChecking.class);
    protected final List<String> list;
    private final Home home;
    protected final List<InstanceChecker> checkers;

    public InstanceChecking(Home home, String[] initialInstanceIDs) {
        this.home = home;
        this.list = Collections.synchronizedList(new ArrayList());
        this.checkers = Collections.synchronizedList(new ArrayList());
        this.addAll(initialInstanceIDs);
    }

    public void addAll(String[] instanceIDs) {
        for (String s : instanceIDs) {
            this.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String itemId) {
        List<String> list = this.list;
        synchronized (list) {
            return this.list.add(itemId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String item) {
        List<String> list = this.list;
        synchronized (list) {
            return this.list.remove(item);
        }
    }

    public boolean addChecker(InstanceChecker c) {
        return this.checkers.add(c);
    }

    public boolean removeChecker(InstanceChecker c) {
        return this.checkers.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Instance Checking running...");
        }
        List<String> list = this.list;
        synchronized (list) {
            String serviceName = this.home.getServiceName();
            Iterator<String> i = this.list.iterator();
            while (i.hasNext()) {
                String uniqueID = i.next();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Checking instance of type " + serviceName + " and id " + uniqueID));
                }
                boolean instanceValid = true;
                try {
                    for (InstanceChecker ic : this.checkers) {
                        if (this.home.isShuttingDown()) {
                            return;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Testing Checker " + ic.getClass().getName()));
                        }
                        if (!ic.check(this.home, uniqueID)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Applying Checker " + ic.getClass().getName()));
                        }
                        instanceValid = ic.process(this.home, uniqueID);
                    }
                    if (instanceValid) continue;
                    i.remove();
                }
                catch (ResourceUnknownException f) {
                    i.remove();
                }
                catch (Throwable e) {
                    logger.warn((Object)("Instance of type " + serviceName + " with id <" + uniqueID + ">"), e);
                }
            }
        }
    }
}

