/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnavailableException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.impl.DefaultHome;
import de.fzj.unicore.wsrflite.impl.InstanceChecker;
import de.fzj.unicore.wsrflite.persistence.Store;
import eu.unicore.util.Log;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ExpiryChecker
implements InstanceChecker {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", ExpiryChecker.class);

    @Override
    public boolean check(Home home, String id) throws ResourceUnknownException, PersistenceException {
        Calendar c = home.getTerminationTime(id);
        if (c == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking <" + home.getServiceName() + ">" + id + " TT = " + c.getTime()));
        }
        boolean comp = c.compareTo(Calendar.getInstance()) <= 0;
        return comp;
    }

    @Override
    public boolean process(Home home, String id) {
        String serviceName = home.getServiceName();
        try {
            logger.debug((Object)("Destroying " + serviceName + "<" + id + ">"));
            Resource i = home.getForUpdate(id);
            try {
                i.destroy();
            }
            catch (Exception ex) {
                Log.logException((String)("Could not perform cleanup for " + serviceName + "<" + id + ">"), (Throwable)ex, (Logger)logger);
            }
            Store s = home.getStore();
            s.unlock(i);
        }
        catch (ResourceUnknownException rue) {
            Log.logException((String)("Could not find instance " + serviceName + "<" + id + ">"), (Throwable)rue, (Logger)logger);
        }
        catch (ResourceUnavailableException e) {
            Log.logException((String)("Could not lock instance " + serviceName + "<" + id + ">"), (Throwable)e, (Logger)logger);
            return true;
        }
        try {
            ((DefaultHome)home).removeFromStorage(id);
        }
        catch (Exception e) {
            Log.logException((String)("Error cleaning up " + serviceName + "<" + id + ">"), (Throwable)e, (Logger)logger);
        }
        return false;
    }
}

