/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.events;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Resource;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;

public abstract class AsynchActionWithCallback<T extends Resource>
implements Runnable {
    protected static final Logger log = Log.getLogger((String)"unicore.wsrflite", AsynchActionWithCallback.class);
    private final Runnable task;
    private final Home home;
    private final String resourceID;

    public AsynchActionWithCallback(Runnable task, Home home, String resourceID) {
        this.task = task;
        this.home = home;
        this.resourceID = resourceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RuntimeException re = null;
        try {
            this.task.run();
        }
        catch (RuntimeException ex) {
            re = ex;
        }
        Resource resource = null;
        try {
            resource = this.home.getForUpdate(this.resourceID);
            if (re == null) {
                this.taskFinished(resource);
            } else {
                this.taskFailed(resource, re);
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Error", (Throwable)ex, (Logger)log);
        }
        finally {
            if (resource != null) {
                try {
                    this.home.persist(resource);
                }
                catch (Exception ex) {
                    Log.logException((String)"Error persisting", (Throwable)ex, (Logger)log);
                }
            }
        }
    }

    public abstract void taskFinished(T var1);

    public abstract void taskFailed(T var1, RuntimeException var2);
}

