/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.admin;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResourceAvailability
implements AdminAction {
    private static final Set<String> resources = Collections.synchronizedSet(new HashSet());

    @Override
    public String getName() {
        return "ToggleResourceAvailability";
    }

    @Override
    public String getDescription() {
        return "'resources' - comma separated list of IDs";
    }

    @Override
    public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
        StringBuilder msg = new StringBuilder();
        String idKey = params.get("resources");
        if (idKey != null) {
            String[] ids;
            for (String id : ids = idKey.split(",")) {
                boolean available = resources.remove(id);
                if (!available) {
                    resources.add(id.trim());
                }
                msg.append(id).append("=").append(available ? "available " : "unavailable ");
            }
        }
        AdminActionResult res = new AdminActionResult(true, msg.toString());
        return res;
    }

    public static boolean isUnavailable(String resourceID) {
        return resources.contains(resourceID);
    }
}

