/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.Kernel;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.Properties;
import org.apache.log4j.Logger;

public class USEContainer {
    private static final Logger logger = Log.getLogger((String)"unicore", USEContainer.class);
    public final Calendar upSince = Calendar.getInstance();
    protected final String name;
    protected final Kernel kernel;

    public String getVersion() {
        return USEContainer.getVersion(this.getClass());
    }

    public static String getVersion(Class<?> versionOf) {
        String version = versionOf.getPackage().getImplementationVersion();
        return version != null ? version : "DEVELOPMENT";
    }

    public final String getHeader() {
        return (this.name == null ? "UNICORE Container (USE)" : this.name) + " version " + this.getVersion();
    }

    public USEContainer(Properties config, String name) throws Exception {
        this.kernel = new Kernel(config);
        this.name = name;
    }

    public USEContainer(String configFile, String name) throws Exception {
        this.kernel = new Kernel(configFile);
        this.name = name;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public String getConnectionStatus() {
        if (!this.kernel.getContainerProperties().getBooleanValue("onstartupSelftest").booleanValue()) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        String newline = System.getProperty("line.separator");
        report.append(newline);
        report.append("Connection status report");
        report.append(newline);
        report.append("************************");
        report.append(newline);
        report.append(this.kernel.getConnectionStatus());
        return report.toString();
    }

    public void startSynchronous() throws Exception {
        this.kernel.startSynchronous();
        this.printInfo();
    }

    private void printInfo() {
        String msg = this.getHeader() + this.getConnectionStatus();
        System.out.println(msg);
        logger.info((Object)msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("ERROR: Configuration file name path must be provided as the first argument. Server NOT started.");
            System.exit(1);
        }
        try {
            System.out.println("Reading config from " + args[0]);
            String name = null;
            if (args.length > 1) {
                name = args[1];
            }
            USEContainer uas = new USEContainer(args[0], name);
            uas.startSynchronous();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("ERROR during server startup, server NOT started.");
            System.exit(1);
        }
    }
}

