/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.StartupTask;
import eu.unicore.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StartupTasksRunner {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", StartupTasksRunner.class);

    public void runStartupTasks(Kernel kernel, Iterable<StartupTask> sl) throws Exception {
        HashMap<String, StartupTask> done = new HashMap<String, StartupTask>();
        HashMap<String, StartupTask> todo = new HashMap<String, StartupTask>();
        for (StartupTask task : sl) {
            if (todo.containsKey(task.getName())) {
                throw new IllegalStateException("Problem with starting init tasks. The task with name " + task.getName() + " is configured twice.");
            }
            todo.put(task.getName(), task);
        }
        int doneNum = 0;
        while (todo.size() > 0) {
            for (StartupTask candidate : todo.values()) {
                if (!this.isEligibleToRun(candidate, done, todo)) continue;
                logger.info((Object)("Running startup task <" + candidate.getName() + ">"));
                if (candidate instanceof KernelInjectable) {
                    ((KernelInjectable)((Object)candidate)).setKernel(kernel);
                }
                candidate.run();
                todo.remove(candidate.getName());
                done.put(candidate.getName(), candidate);
                break;
            }
            if (done.size() == doneNum) {
                throw new IllegalStateException("Problem with starting init tasks. The dependencies between tasks can't be satisfied. There are the following not invoked tasks: " + todo.keySet() + " and the following were run: " + done.keySet());
            }
            ++doneNum;
        }
    }

    private boolean isEligibleToRun(StartupTask candidate, Map<String, StartupTask> done, Map<String, StartupTask> todo) {
        for (String after : candidate.getAfter()) {
            if (done.containsKey(after)) continue;
            return false;
        }
        for (StartupTask other : todo.values()) {
            if (other.equals(candidate) || !other.getBefore().contains(candidate)) continue;
            return false;
        }
        return true;
    }
}

